/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.population;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugins.admin.notificator.AbstractConfigurableAdministratorNotificator;
import org.ametys.runtime.plugins.admin.notificator.Notification;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class MisconfiguredPopulationAdministratorNotificator
extends AbstractConfigurableAdministratorNotificator
implements Serviceable {
    private UserPopulationDAO _userPopulationDAO;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._i18nUtils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
    }

    @Override
    public List<Notification> getNotifications() {
        Set<String> misconfiguredPopulations = this._userPopulationDAO.getMisconfiguredPopulations();
        if (!misconfiguredPopulations.isEmpty()) {
            I18nizableText message = this._getMessage(misconfiguredPopulations);
            Notification notification = new Notification(this._getType(misconfiguredPopulations), this._title, message, this._iconGlyph, this._action);
            return Collections.singletonList(notification);
        }
        return Collections.EMPTY_LIST;
    }

    private Notification.NotificationType _getType(Set<String> upIds) {
        for (String id : upIds) {
            UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(id);
            if (!userPopulation.isEnabled()) continue;
            return Notification.NotificationType.ERROR;
        }
        return Notification.NotificationType.WARN;
    }

    private I18nizableText _getMessage(Set<String> upIds) {
        StringBuilder sb = new StringBuilder();
        for (String id : upIds) {
            UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(id);
            String upLabel = this._i18nUtils.translate(userPopulation.getLabel());
            sb.append("<li>").append(upLabel).append("</li>");
        }
        String i18nParam = sb.toString();
        return new I18nizableText(this._message.getCatalogue(), this._message.getKey(), Collections.singletonList(i18nParam));
    }
}

