/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.population;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.tuple.Pair;

public class PopulationContextHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = PopulationContextHelper.class.getName();
    public static final String CONTEXTS_CACHE_KEY = ROLE + "$CONTEXTS";
    public static final String SHARED_CONTEXTS_CACHE_KEY = ROLE + "$SHARED_CONTEXTS";
    public static final String POPULATION_CONTEXTS_REQUEST_ATTR = "populationContexts";
    public static final String ADMIN_CONTEXT = "/admin";
    protected static final String __USER_POPULATIONS_TABLE = "UserPopulationsByContext";
    protected static final String __ADMIN_RIGHT_ACCESS = "Runtime_Rights_Admin_Access";
    private static final Comparator<Pair<String, Integer>> _COMPARATOR = Comparator.comparingInt(Pair::getRight);
    private static final String IS_CACHE_FILLED = "###iscachefilled###";
    protected ServiceManager _manager;
    private UserPopulationDAO _userPopulationDAO;
    private ObservationManager _observationManager;
    private CurrentUserProvider _currentUserProvider;
    private RightManager _rightManager;
    private AbstractCacheManager _abstractCacheManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._abstractCacheManager = (AbstractCacheManager)this._manager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        this._abstractCacheManager.createMemoryCache(CONTEXTS_CACHE_KEY, new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_POPULATION_CONTEXT_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_POPULATION_CONTEXT_DESCRIPTION"), true, null);
        this._abstractCacheManager.createMemoryCache(SHARED_CONTEXTS_CACHE_KEY, new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_POPULATION_SHARED_CONTEXT_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_POPULATION_SHARED_CONTEXT_DESCRIPTION"), true, null);
    }

    protected ObservationManager getObservationManager() {
        if (this._observationManager == null) {
            try {
                this._observationManager = (ObservationManager)((Object)this._manager.lookup(ObservationManager.ROLE));
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._observationManager;
    }

    protected UserPopulationDAO getUserPopulationDAO() {
        if (this._userPopulationDAO == null) {
            try {
                this._userPopulationDAO = (UserPopulationDAO)this._manager.lookup(UserPopulationDAO.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._userPopulationDAO;
    }

    protected CurrentUserProvider getCurrentUserProvider() {
        if (this._currentUserProvider == null) {
            try {
                this._currentUserProvider = (CurrentUserProvider)this._manager.lookup(CurrentUserProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._currentUserProvider;
    }

    protected RightManager getRightManager() {
        if (this._rightManager == null) {
            try {
                this._rightManager = (RightManager)this._manager.lookup(RightManager.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._rightManager;
    }

    protected Connection getSQLConnection() {
        String datasourceId = (String)Config.getInstance().getValue("runtime.assignments.userpopulations");
        return ConnectionHelper.getConnection(datasourceId);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Set<String> link(String context, Collection<String> ids) {
        Set<String> result = this.getUserPopulationsOnContext(context, true);
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = this.getSQLConnection();
            String sql = "DELETE FROM UserPopulationsByContext WHERE Context=?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, context);
            stmt.executeUpdate();
            this.getLogger().info("{}\n[{}]", (Object)sql, (Object)context);
            sql = "INSERT INTO UserPopulationsByContext (Context, Ordering, UserPopulation_Id) VALUES(?, ?, ?)";
            stmt = connection.prepareStatement(sql);
            int index = 0;
            for (String id : ids) {
                if (this.getUserPopulationDAO().getUserPopulation(id) != null) {
                    stmt.setString(1, context);
                    stmt.setInt(2, index);
                    stmt.setString(3, id);
                    stmt.executeUpdate();
                    this.getLogger().info("{}\n[{}, {}, {}]", new Object[]{sql, context, index, id});
                    if (result.contains(id)) {
                        result.remove(id);
                    } else {
                        result.add(id);
                    }
                } else {
                    this.getLogger().warn("The user population with id '{}' does not exist. It will not be linked.", (Object)id);
                }
                ++index;
            }
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("SQL error while linking user populations to a context", e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(connection);
                ConnectionHelper.cleanup(stmt);
                this.__getContextCache().invalidateAll();
                this._abstractCacheManager.get(SHARED_CONTEXTS_CACHE_KEY).invalidateAll();
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(connection);
        ConnectionHelper.cleanup(stmt);
        this.__getContextCache().invalidateAll();
        this._abstractCacheManager.get(SHARED_CONTEXTS_CACHE_KEY).invalidateAll();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("userpopulation-ids", ids);
        eventParams.put("userpopulation-context", context);
        this.getObservationManager().notify(new Event("userpopulations.assignment", this.getCurrentUserProvider().getUser(), eventParams));
        return result;
    }

    public Set<String> getContextsForUserPopulation(String userPopulationId) {
        return this._getContextCacheAsMap().entrySet().stream().filter(entry -> ((Set)entry.getValue()).stream().anyMatch(pair -> userPopulationId.equals(pair.getLeft()))).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<String> getSharedContextsForUserPopulations(String userPopulation1, String userPopulation2) {
        Cache<SharedContextsKey, Set> cache = this._abstractCacheManager.get(SHARED_CONTEXTS_CACHE_KEY);
        SharedContextsKey key = new SharedContextsKey(userPopulation1, userPopulation2);
        return cache.get(key, k -> {
            HashSet<String> sharedContexts = new HashSet<String>();
            Map<String, Set<Pair<String, Integer>>> contextCacheAsMap = this._getContextCacheAsMap();
            for (String context : contextCacheAsMap.keySet()) {
                sharedContexts.addAll(this._getSharedCompatibleContexts(contextCacheAsMap, context, userPopulation1, userPopulation2));
            }
            return sharedContexts;
        });
    }

    protected Set<String> _getSharedCompatibleContexts(Map<String, Set<Pair<String, Integer>>> contextCacheAsMap, String context, String userPopulation1, String userPopulation2) {
        Set populationsForContext = contextCacheAsMap.get(context).stream().map(Pair::getLeft).collect(Collectors.toSet());
        if (populationsForContext.contains(userPopulation1) && populationsForContext.contains(userPopulation2)) {
            return Set.of(context);
        }
        return Set.of();
    }

    public Set<String> getUserPopulationsOnContext(String context, boolean withDisabled) {
        if (ADMIN_CONTEXT.equals(context)) {
            List<UserPopulation> populations = withDisabled ? this.getUserPopulationDAO().getUserPopulations(true) : this.getUserPopulationDAO().getEnabledUserPopulations(true);
            return populations.stream().map(UserPopulation::getId).collect(Collectors.toSet());
        }
        return this._getPopulationsOnContextFromDatabase(context, withDisabled);
    }

    public Set<String> getUserPopulationsOnContexts(Collection<String> contexts, boolean withDisabled, boolean checkRights) {
        UserIdentity currentUser = this.getCurrentUserProvider().getUser();
        if (checkRights && contexts.contains(ADMIN_CONTEXT) && this.getRightManager().currentUserHasRight(__ADMIN_RIGHT_ACCESS, ADMIN_CONTEXT) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User " + String.valueOf(this.getCurrentUserProvider().getUser()) + " tried to access the list of all user populations without convenient rights");
        }
        if (!checkRights) {
            return contexts.stream().map(context -> this.getUserPopulationsOnContext((String)context, withDisabled)).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        if (currentUser == null) {
            throw new AccessDeniedException("Anonymous user tried to access the list of user populations on contexts '" + StringUtils.join(contexts, (String)",") + "'.");
        }
        boolean isAdministrator = this.getRightManager().currentUserHasRight(__ADMIN_RIGHT_ACCESS, ADMIN_CONTEXT) == RightManager.RightResult.RIGHT_ALLOW;
        HashSet<String> populations = new HashSet<String>();
        for (String context2 : contexts) {
            Set<String> ctxPopulations = this.getUserPopulationsOnContext(context2, withDisabled);
            if (!ctxPopulations.contains(currentUser.getPopulationId()) && !isAdministrator) {
                throw new AccessDeniedException("User " + String.valueOf(currentUser) + " tried to access the list of user populations on context '" + context2 + "', but he does not belong to any populations on this context.");
            }
            populations.addAll(ctxPopulations);
        }
        return populations;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Set<String> getUserPopulationsOnContexts(Collection<String> contexts, boolean withDisabled) {
        return this.getUserPopulationsOnContexts(contexts, withDisabled, true);
    }

    private Set<String> _getPopulationsOnContextFromDatabase(String context, boolean withDisabled) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Pair pair : this._getContextCacheAsMap().getOrDefault(context, Collections.emptySet())) {
            String userPopulationId = (String)pair.getLeft();
            if (withDisabled || this.getUserPopulationDAO().getUserPopulation(userPopulationId).isEnabled()) {
                result.add(userPopulationId);
                continue;
            }
            this.getLogger().warn("The population of id '{}' is linked to a context but disabled. It will not be returned.", (Object)userPopulationId);
        }
        return result;
    }

    private synchronized Map<String, Set<Pair<String, Integer>>> _getAllPopulationContent() {
        HashMap<String, Set<Pair<String, Integer>>> cache = new HashMap<String, Set<Pair<String, Integer>>>();
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sql = "SELECT Context, Ordering, UserPopulation_Id FROM UserPopulationsByContext";
            stmt = connection.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String context = rs.getString(1);
                Integer ordering = rs.getInt(2);
                String userPopulationId = rs.getString(3);
                if (this.getUserPopulationDAO().getUserPopulation(userPopulationId) == null) {
                    this.getLogger().warn("The population of id '{}' is linked to a context, but does not exist anymore.", (Object)userPopulationId);
                    continue;
                }
                Set cacheForContext = cache.computeIfAbsent(context, c -> new TreeSet<Pair<String, Integer>>(_COMPARATOR));
                cacheForContext.add(Pair.of((Object)userPopulationId, (Object)ordering));
            }
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("Cannot get populations and contexts association because of an error in a sql query", e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(connection);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(rs);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(connection);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(rs);
        return cache;
    }

    private Cache<String, Set<Pair<String, Integer>>> __getContextCache() {
        return this._abstractCacheManager.get(CONTEXTS_CACHE_KEY);
    }

    protected synchronized Cache<String, Set<Pair<String, Integer>>> _getContextCache() {
        Cache<String, Set<Pair<String, Integer>>> cache = this.__getContextCache();
        if (!cache.hasKey(IS_CACHE_FILLED)) {
            Map<String, Set<Pair<String, Integer>>> cacheMap = this._getAllPopulationContent();
            cache.putAll(cacheMap);
            cache.put(IS_CACHE_FILLED, null);
        }
        return cache;
    }

    protected synchronized Map<String, Set<Pair<String, Integer>>> _getContextCacheAsMap() {
        Map<String, Set<Pair<String, Integer>>> cacheAsMap = this._getContextCache().asMap();
        cacheAsMap.remove(IS_CACHE_FILLED);
        return cacheAsMap;
    }

    public boolean isLinked(String upId) {
        return this._getContextCacheAsMap().values().stream().flatMap(s -> s.stream()).map(Pair::getLeft).anyMatch(u -> Strings.CS.equals(u, upId));
    }

    static class SharedContextsKey
    extends AbstractCacheKey {
        SharedContextsKey(String userPopulationA, String userPopulationB) {
            super(userPopulationA.compareTo(userPopulationB) < 0 ? userPopulationA : userPopulationB, userPopulationA.compareTo(userPopulationB) < 0 ? userPopulationB : userPopulationA);
        }
    }
}

