/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.status;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.ametys.core.user.status.PersonalDataProcessingException;
import org.ametys.core.user.status.UserStatusInfo;

public interface PersonalDataPolicy {
    public AnonymizationResult process(UserStatusInfo var1) throws PersonalDataProcessingException;

    public static enum AnonymizationResult {
        ERROR,
        TOO_EARLY,
        PARTIALLY_PROCESSED,
        PROCESSED,
        NO_DATA;


        public static AnonymizationResult merge(Collection<AnonymizationResult> results) {
            return results.stream().filter(r -> r != null).min(Comparator.naturalOrder()).orElse(NO_DATA);
        }

        public static AnonymizationResult merge(AnonymizationResult ... results) {
            return Arrays.stream(results).filter(r -> r != null).min(Comparator.naturalOrder()).orElse(NO_DATA);
        }
    }
}

