/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.status;

import java.util.Map;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.user.status.PersonalDataPolicy;
import org.ametys.core.user.status.UserStatusInfo;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;

public class PersonalDataPolicyExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<PersonalDataPolicy> {
    public static final String ROLE = PersonalDataPolicyExtensionPoint.class.getName();

    public PersonalDataPolicy.AnonymizationResult process(UserStatusInfo userStatusInfo) {
        PersonalDataPolicy.AnonymizationResult result = PersonalDataPolicy.AnonymizationResult.NO_DATA;
        for (String policyId : this.getExtensionsIds()) {
            try {
                PersonalDataPolicy policy = (PersonalDataPolicy)this.getExtension(policyId);
                PersonalDataPolicy.AnonymizationResult policyResult = policy.process(userStatusInfo);
                switch (policyResult) {
                    case ERROR: {
                        ForensicLogger.warn("data.policy.gdpr", Map.of(policyId, policyResult.name(), "identity", userStatusInfo.getUserIdentity()), UserPopulationDAO.SYSTEM_USER_IDENTITY);
                        break;
                    }
                    default: {
                        ForensicLogger.info("data.policy.gdpr", Map.of(policyId, policyResult.name(), "identity", userStatusInfo.getUserIdentity()), UserPopulationDAO.SYSTEM_USER_IDENTITY);
                    }
                }
                result = PersonalDataPolicy.AnonymizationResult.merge(result, policyResult);
            }
            catch (Exception e) {
                this.getLogger().error("An error prevented the enforcement of data policy '{}' for the identity '{}'", new Object[]{policyId, userStatusInfo.getUserIdentity(), e});
                result = PersonalDataPolicy.AnonymizationResult.ERROR;
            }
        }
        return result;
    }
}

