/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.status;

import java.util.List;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.user.status.PersonalDataPolicy;
import org.ametys.core.user.status.PersonalDataPolicyExtensionPoint;
import org.ametys.core.user.status.UserStatusInfo;
import org.ametys.core.user.status.UserStatusManager;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobExecutionContext;

public class RemovePersonalDataSchedulable
extends AbstractStaticSchedulable {
    protected UserStatusManager _userStatusManager;
    protected PersonalDataPolicyExtensionPoint _personalDataPolicyEP;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._personalDataPolicyEP = (PersonalDataPolicyExtensionPoint)manager.lookup(PersonalDataPolicyExtensionPoint.ROLE);
        this._userStatusManager = (UserStatusManager)manager.lookup(UserStatusManager.ROLE);
    }

    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        List<UserStatusInfo> unknownUsersWithDataRemovalActive = this._userStatusManager.getUnknownUsersWithDataRemovalActive();
        progressionTracker.setSize((long)unknownUsersWithDataRemovalActive.size(), new I18nizableText("plugin.core", "PLUGINS_CORE_PERSONAL_DATA_REMOVAL_SCHEDULABLE_PROCESS_USERS_STEP"));
        for (UserStatusInfo unknownUser : unknownUsersWithDataRemovalActive) {
            PersonalDataPolicy.AnonymizationResult result = this._personalDataPolicyEP.process(unknownUser);
            switch (result) {
                case NO_DATA: 
                case PROCESSED: {
                    this._userStatusManager.remove(unknownUser.getUserIdentity());
                    break;
                }
            }
            progressionTracker.increment();
        }
    }
}

