/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.status;

import java.time.Instant;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.datasource.AbstractMyBatisDAO;
import org.ametys.core.datasource.ZonedDateTimeTypeHandler;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.schedule.progression.SimpleProgressionTracker;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.user.status.UserStatusInfo;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.DeferredServiceable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class UserStatusManager
extends AbstractMyBatisDAO
implements DeferredServiceable {
    public static final String ROLE = UserStatusManager.class.getName();
    protected UserManager _userManager;
    protected UserPopulationDAO _userPopulationDAO;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
    }

    @Override
    public void deferredService(ServiceManager manager) throws ServiceException {
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
    }

    @Override
    protected Configuration _getMyBatisConfiguration(Environment env) {
        Configuration config = super._getMyBatisConfiguration(env);
        TypeHandlerRegistry typeHandlerRegistry = config.getTypeHandlerRegistry();
        typeHandlerRegistry.register(ZonedDateTime.class, JdbcType.TIMESTAMP, ZonedDateTimeTypeHandler.class);
        typeHandlerRegistry.register(ZonedDateTime.class, null, ZonedDateTimeTypeHandler.class);
        return config;
    }

    public Optional<ZonedDateTime> getLastConnectionDate(UserIdentity user) {
        try (SqlSession session = this.getSession();){
            Optional<ZonedDateTime> optional = Optional.ofNullable((ZonedDateTime)session.selectOne("UserStatus.getLastConnectionDate", (Object)user));
            return optional;
        }
    }

    public void updateConnectionDate(UserIdentity userIdentity) {
        Instant now = Instant.now();
        User user = this._userManager.getUser(userIdentity);
        if (user != null) {
            try (SqlSession session = this.getSession(true);){
                Map<String, Instant> params = Map.of("login", userIdentity.getLogin(), "populationId", userIdentity.getPopulationId(), "firstname", user.getFirstName(), "lastname", user.getLastName(), "email", user.getEmail(), "lastConnectionDate", now);
                int update = session.update("UserStatus.updateLastConnectionDate", params);
                if (update == 0) {
                    session.update("UserStatus.addUserStatusInfo", params);
                }
            }
            catch (Exception e) {
                this.getLogger().warn("An error prevented updating the last connection date for {}", (Object)userIdentity, (Object)e);
            }
        } else {
            this.getLogger().warn("Connection date update for {} was ignored because there is no user for the identity", (Object)userIdentity);
        }
    }

    @Callable(rights={"Runtime_Rights_Unknown_Users"})
    public Map<String, Object> searchUnknownUsers(String pattern, int offset, int limit, List<Map<String, String>> sorts) {
        try (SqlSession session = this.getSession();){
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotEmpty((CharSequence)pattern)) {
                params.put("pattern", StringUtils.lowerCase((String)pattern));
            }
            if (sorts == null || sorts.isEmpty()) {
                params.put("sorts", List.of(Map.of("property", "missing_date", "direction", "ASC")));
            } else {
                params.put("sorts", sorts);
            }
            List<Map> users = session.selectList("UserStatus.searchUnknownUsers", params, new RowBounds(offset, limit)).stream().map(UserStatusInfo::toJSON).map(json -> {
                UserPopulation userPopulation;
                String populationId = (String)json.get("populationId");
                if (populationId != null && (userPopulation = this._userPopulationDAO.getUserPopulation(populationId)) != null) {
                    json.put("populationLabel", userPopulation.getLabel());
                }
                return json;
            }).toList();
            int total = (Integer)session.selectOne("UserStatus.getUnknownUsersCount", (Object)pattern);
            Map<String, Object> map = Map.of("unknownUsers", users, "total", total);
            return map;
        }
    }

    public List<UserStatusInfo> getUnknownUsersWithDataRemovalActive() {
        try (SqlSession session = this.getSession();){
            List list = session.selectList("UserStatus.searchUnknownUsers", Map.of("forget", true));
            return list;
        }
    }

    public void activatePersonalDataRemoval(List<UserIdentity> identities) {
        if (!identities.isEmpty()) {
            this._forgetUsers(identities, true);
        }
    }

    public void deactivatePersonalDataRemoval(List<UserIdentity> identities) {
        if (!identities.isEmpty()) {
            this._forgetUsers(identities, false);
        }
    }

    private void _forgetUsers(List<UserIdentity> identities, boolean forget) {
        try (SqlSession session = this.getSession(true);){
            session.update("UserStatus.forgetUsers", Map.of("identities", identities, "forget", forget));
        }
    }

    public void updateStatusOfInactiveUsers(int monthDelay, ContainerProgressionTracker progressionTracker) {
        Period delay = Period.ofMonths(monthDelay);
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime threshold = now.minus(delay);
        try (SqlSession session = this.getSession(true);){
            List inactiveUsersInfo = session.selectList("UserStatus.getInactiveUsers", (Object)threshold);
            int nbInactiveUser = inactiveUsersInfo.size();
            SimpleProgressionTracker updateStep = progressionTracker.addSimpleStep("update", new I18nizableText("plugin.core", "PLUGIN_CORE_USER_STATUS_UPDATE_PROGRESSION_LABEL", Map.of("count", new I18nizableText(Integer.toString(nbInactiveUser)), "delay", new I18nizableText(Integer.toString(monthDelay)))));
            updateStep.setSize(nbInactiveUser);
            int missingInAction = 0;
            for (UserStatusInfo userInfo : inactiveUsersInfo) {
                UserIdentity identity = userInfo.getUserIdentity();
                User user = this._userManager.getUser(identity);
                ZonedDateTime storedMissingDate = userInfo.getMissingSinceDate();
                if (user == null && storedMissingDate == null) {
                    session.update("UserStatus.markUnknown", Map.of("identity", identity, "missingDate", now));
                    this.getLogger().debug("{} is now missing", (Object)identity);
                    ++missingInAction;
                } else if (user != null && storedMissingDate != null) {
                    session.update("UserStatus.unmarkUnknown", (Object)identity);
                    this.getLogger().warn("Missing user {} is not considered missing anymore", (Object)identity);
                }
                updateStep.increment();
            }
            this.getLogger().info("Update of inactive user status resulted in {} new user(s) considered missing", (Object)missingInAction);
        }
    }

    public void remove(UserIdentity userIdentity) {
        try (SqlSession session = this.getSession(true);){
            session.delete("UserStatus.deleteUserStatusInfo", (Object)userIdentity);
        }
    }
}

