/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.userpref;

import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Map;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.user.status.PersonalDataPolicy;
import org.ametys.core.user.status.PersonalDataProcessingException;
import org.ametys.core.user.status.UserStatusInfo;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UserPreferenceDataPolicy
implements PersonalDataPolicy,
Serviceable {
    protected ServiceManager _serviceManager;
    protected UserPreferencesManager _userPrefManager;
    private Period _retentionPeriod;

    public void service(ServiceManager manager) throws ServiceException {
        this._serviceManager = manager;
        this._userPrefManager = (UserPreferencesManager)((Object)manager.lookup(UserPreferencesManager.ROLE));
        Long config = Config.getInstance().getValue("runtime.data.policy.userpref.retention", false, null);
        this._retentionPeriod = config != null && config >= 0L ? Period.ofMonths(config.intValue()) : null;
    }

    @Override
    public PersonalDataPolicy.AnonymizationResult process(UserStatusInfo userStatus) throws PersonalDataProcessingException {
        if (this._retentionPeriod == null) {
            return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
        }
        if (userStatus.getMissingSinceDate().isBefore(ZonedDateTime.now().minus(this._retentionPeriod))) {
            try {
                this._userPrefManager.removeAllUserPreferences(userStatus.getUserIdentity(), null, Map.of());
                ForensicLogger.info("data.policy.gdpr.remove.user.preferences", Map.of("identity", userStatus.getUserIdentity()), UserPopulationDAO.SYSTEM_USER_IDENTITY);
                return PersonalDataPolicy.AnonymizationResult.PROCESSED;
            }
            catch (UserPreferencesException e) {
                throw new PersonalDataProcessingException("An error prevented the processing of the preference for user '" + String.valueOf(userStatus.getUserIdentity()) + "'.", e);
            }
        }
        return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
    }
}

