/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.userpref;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.dataprovider.UserDataProvider;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesExtensionPoint;
import org.ametys.core.userpref.UserPreferencesImageAccessor;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.ui.user.DefaultProfileImageProvider;
import org.ametys.plugins.core.ui.user.ProfileImageProvider;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class UserPreferencesDataProvider
extends AbstractLogEnabled
implements UserDataProvider,
Serviceable {
    public static final String USER_PREFERENCES_DATA_PROVIDER_ID = UserPreferencesDataProvider.class.getName();
    protected static List<String> _supportedElements = new ArrayList<String>(List.of("image", "timezone", "language"));
    protected UserPreferencesExtensionPoint _userPrefEP;
    protected UserPreferencesManager _userPrefManager;
    protected ProfileImageProvider _imageProvider;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPrefEP = (UserPreferencesExtensionPoint)manager.lookup(UserPreferencesExtensionPoint.ROLE);
        this._userPrefManager = (UserPreferencesManager)((Object)manager.lookup(UserPreferencesManager.ROLE));
        this._imageProvider = (ProfileImageProvider)manager.lookup(ProfileImageProvider.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    @Override
    public int getPriority() {
        return 20000;
    }

    @Override
    public boolean supports(String element) {
        return _supportedElements.contains(element);
    }

    @Override
    public Object getValue(User user, String dataId) {
        try {
            if ("image".equals(dataId)) {
                return this._getUserPrefImageAccessor(user.getIdentity());
            }
            Map<String, String> userPref = this._userPrefManager.getUnTypedUserPrefs(user.getIdentity(), "", Collections.EMPTY_MAP);
            if (userPref != null && userPref.get(dataId) != null && StringUtils.isNotBlank((CharSequence)userPref.get(dataId))) {
                return userPref.get(dataId);
            }
        }
        catch (UserPreferencesException e) {
            this.getLogger().warn("An error occurred while retrieving user preference of user {}", (Object)user.getIdentity(), (Object)e);
        }
        return null;
    }

    private UserPreferencesImageAccessor _getUserPrefImageAccessor(UserIdentity user) {
        Map<String, Object> userPrefImgData = this._getRawUserPrefImage(user);
        if (userPrefImgData != null) {
            String rawImageSource = (String)userPrefImgData.remove("source");
            DefaultProfileImageProvider.ProfileImageSource profileImageSource = this.getProfileImageSource(rawImageSource);
            if (profileImageSource == null) {
                return null;
            }
            Map sourceParams = (Map)userPrefImgData.get("parameters");
            return new UserPreferencesImageAccessor(user, profileImageSource, sourceParams, this._imageProvider);
        }
        return null;
    }

    private Map<String, Object> _getRawUserPrefImage(UserIdentity user) {
        try {
            String userPrefImgJson = this._userPrefManager.getUserPreferenceAsString(user, "", Collections.EMPTY_MAP, "profile-image");
            if (StringUtils.isNotEmpty((CharSequence)userPrefImgJson)) {
                return this._jsonUtils.convertJsonToMap(userPrefImgJson);
            }
        }
        catch (Exception e) {
            this.getLogger().error(String.format("Unable to retrieve the '%s' userpref for user '%s'", "profile-image", user), (Throwable)e);
        }
        return null;
    }

    public DefaultProfileImageProvider.ProfileImageSource getProfileImageSource(String imageSourceStr) {
        DefaultProfileImageProvider.ProfileImageSource profileImageSource = null;
        try {
            profileImageSource = DefaultProfileImageProvider.ProfileImageSource.valueOf(imageSourceStr.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return profileImageSource;
    }
}

