/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.userpref;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.core.userpref.UserPreferencesExtensionPoint;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemContainer;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UserPreferencesEnumerator
extends AbstractLogEnabled
implements Enumerator<String>,
Contextualizable,
Serviceable {
    protected UserPreferencesExtensionPoint _userPrefEP;
    protected Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._userPrefEP = (UserPreferencesExtensionPoint)serviceManager.lookup(UserPreferencesExtensionPoint.ROLE);
    }

    @Override
    public Map<String, I18nizableText> getEntries() throws Exception {
        Map<String, String> contextVars = this.getContextVars();
        View view = this._userPrefEP.getUserPreferencesView(contextVars);
        return this._getEntries(view);
    }

    private Map<String, I18nizableText> _getEntries(ViewItemContainer viewItemContainer) {
        LinkedHashMap<String, I18nizableText> entries = new LinkedHashMap<String, I18nizableText>();
        for (ViewItem viewItem : viewItemContainer.getViewItems()) {
            if (viewItem instanceof ViewElement) {
                ViewElement viewElement = (ViewElement)viewItem;
                ElementDefinition userPreference = viewElement.getDefinition();
                entries.put(userPreference.getName(), userPreference.getLabel());
                continue;
            }
            if (!(viewItem instanceof ViewItemContainer)) continue;
            ViewItemContainer group = (ViewItemContainer)((Object)viewItem);
            entries.putAll(this._getEntries(group));
        }
        return entries;
    }

    @Override
    public I18nizableText getEntry(String value) throws Exception {
        Map<String, String> contextVars = this.getContextVars();
        return this._userPrefEP.getUserPreference(contextVars, value).getLabel();
    }

    protected Map<String, String> getContextVars() {
        return Collections.emptyMap();
    }
}

