/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.userpref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.userpref.UserPreferenceProvider;
import org.ametys.core.util.I18nizableTextKeyComparator;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.CategorizedElementDefinitionHelper;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;

public class UserPreferencesExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<UserPreferenceProvider> {
    public static final String ROLE = UserPreferencesExtensionPoint.class.getName();

    public UserPreference getUserPreference(Map<String, String> contextVars, String name) {
        return this.getUserPreferences(contextVars).stream().filter(userPreference -> name.equals(userPreference.getName())).findFirst().orElse(null);
    }

    public Collection<UserPreference> getUserPreferences(Map<String, String> contextVars) {
        ArrayList<UserPreference> userPreferences = new ArrayList<UserPreference>();
        for (String extensionId : this.getExtensionsIds()) {
            UserPreferenceProvider provider = (UserPreferenceProvider)this.getExtension(extensionId);
            userPreferences.addAll(provider.getPreferences(contextVars));
        }
        return userPreferences;
    }

    public View getUserPreferencesView(Map<String, String> contextVars) {
        return this.getUserPreferencesView(false, contextVars);
    }

    public View getUserPreferencesView(boolean excludePrivate, Map<String, String> contextVars) {
        Collection<UserPreference> preferences = this.getUserPreferences(contextVars);
        I18nizableTextKeyComparator groupsComparator = new I18nizableTextKeyComparator();
        UserPreferencesPositionComparator userPreferencesComparator = new UserPreferencesPositionComparator(this);
        return this._buildView(preferences, groupsComparator, userPreferencesComparator, excludePrivate);
    }

    private View _buildView(Collection<UserPreference> wrappers, Comparator<I18nizableText> groupsComparator, Comparator<UserPreference> userPreferencesComparator, boolean excludePrivate) {
        View view = new View();
        Map<I18nizableText, Collection<UserPreference>> groups = this._groupUserPreferences(wrappers);
        Collection<I18nizableText> sortedGroups = CategorizedElementDefinitionHelper.sortItemsList(groups.keySet(), groupsComparator);
        for (I18nizableText groupLabel : sortedGroups) {
            ViewItem groupViewItem = this._buildGroupViewItem(groupLabel, groups.get(groupLabel), userPreferencesComparator, excludePrivate);
            view.addViewItem(groupViewItem);
        }
        return view;
    }

    private Map<I18nizableText, Collection<UserPreference>> _groupUserPreferences(Collection<UserPreference> preferences) {
        HashMap<I18nizableText, Collection<UserPreference>> groups = new HashMap<I18nizableText, Collection<UserPreference>>();
        for (UserPreference preference : preferences) {
            I18nizableText displayGroup = preference.getDisplayGroup();
            Collection group = groups.computeIfAbsent(displayGroup, __ -> new ArrayList());
            group.add(preference);
        }
        return groups;
    }

    private ViewItem _buildGroupViewItem(I18nizableText groupLabel, Collection<UserPreference> preferences, Comparator<UserPreference> userPreferencesComparator, boolean excludePrivate) throws IllegalArgumentException {
        SimpleViewItemGroup groupViewItem = new SimpleViewItemGroup();
        groupViewItem.setRole("fieldset");
        groupViewItem.setLabel(groupLabel);
        Collection<UserPreference> items = CategorizedElementDefinitionHelper.sortItemsList(preferences, userPreferencesComparator);
        for (UserPreference item : items) {
            if (item.isPrivate() && excludePrivate) continue;
            ViewElement userPreferenceViewItem = new ViewElement();
            userPreferenceViewItem.setDefinition(item);
            groupViewItem.addViewItem(userPreferenceViewItem);
        }
        return groupViewItem;
    }

    class UserPreferencesPositionComparator
    implements Comparator<UserPreference> {
        UserPreferencesPositionComparator(UserPreferencesExtensionPoint this$0) {
        }

        @Override
        public int compare(UserPreference preference1, UserPreference preference2) {
            int positionComparison = CategorizedElementDefinitionHelper.comparePositions(preference1.getPosition(), preference2.getPosition());
            if (positionComparison != 0) {
                return positionComparison;
            }
            return preference1.compareTo(preference2);
        }
    }
}

