/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.DevMode;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.ImageResolverHelper;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.dom.AmetysNodeList;
import org.ametys.core.util.dom.MapElement;
import org.ametys.core.util.dom.StringElement;
import org.ametys.core.version.Version;
import org.ametys.core.version.VersionsHandler;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.ametys.runtime.workspace.WorkspaceManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.LookupTranslator;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AmetysXSLTHelper
implements Contextualizable,
Serviceable {
    protected static final Logger _LOGGER = LoggerFactory.getLogger((String)AmetysXSLTHelper.class.getName());
    protected static I18nUtils _i18nUtils;
    protected static VersionsHandler _versionHandler;
    protected static CurrentUserProvider _currentUserProvider;
    protected static GroupManager _groupManager;
    protected static UserHelper _userHelper;
    protected static JSONUtils _jsonUtils;
    protected static RightManager _rightManager;
    protected static UserManager _userManager;
    protected static SourceResolver _sourceResolver;
    private static Context _context;

    public void contextualize(Context context) throws ContextException {
        _context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        _i18nUtils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
        _versionHandler = (VersionsHandler)manager.lookup(VersionsHandler.ROLE);
        _currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        _groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
        _userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        _jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        _rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        _userManager = (UserManager)manager.lookup(UserManager.ROLE);
        _sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public static String uriPrefix() {
        return AmetysXSLTHelper.uriPrefix(true);
    }

    public static String uriPrefix(boolean withWorkspaceURI) {
        return AmetysXSLTHelper.getUriPrefix(withWorkspaceURI);
    }

    public static String absoluteUriPrefix() {
        return AmetysXSLTHelper.absoluteUriPrefix(true);
    }

    public static String absoluteUriPrefix(boolean withWorkspaceURI) {
        return AmetysXSLTHelper.getAbsoluteUriPrefix(withWorkspaceURI);
    }

    public static String workspaceName() {
        return AmetysXSLTHelper.getWorkspaceName();
    }

    public static String workspacePrefix() {
        return AmetysXSLTHelper.getWorkspacePrefix();
    }

    public static String workspaceTheme() {
        Request request = ContextHelper.getRequest((Context)_context);
        return (String)request.getAttribute("workspaceTheme");
    }

    public static String workspaceThemeURL() {
        Request request = ContextHelper.getRequest((Context)_context);
        String workspaceThemeUrl = (String)request.getAttribute("workspaceThemeURL");
        if (workspaceThemeUrl == null) {
            String workspaceName = RuntimeConfig.getInstance().getDefaultWorkspace();
            WorkspaceManager wm = WorkspaceManager.getInstance();
            if (wm.getWorkspaceNames().contains(workspaceName)) {
                workspaceThemeUrl = wm.getWorkspaces().get(workspaceName).getThemeURL();
            }
        }
        return workspaceThemeUrl;
    }

    protected static String getUriPrefix(boolean withWorkspaceURI) {
        Request request = ContextHelper.getRequest((Context)_context);
        String workspaceURI = withWorkspaceURI ? AmetysXSLTHelper.getWorkspacePrefix() : "";
        return request.getContextPath() + workspaceURI;
    }

    protected static String getAbsoluteUriPrefix(boolean withWorkspaceURI) {
        Request request = ContextHelper.getRequest((Context)_context);
        Object uriPrefix = AmetysXSLTHelper.getUriPrefix(withWorkspaceURI);
        if (!((String)uriPrefix).startsWith("http")) {
            uriPrefix = request.getScheme() + "://" + request.getServerName() + (String)(request.getServerPort() != 80 ? ":" + request.getServerPort() : "") + (String)uriPrefix;
        }
        return uriPrefix;
    }

    protected static String getWorkspaceName() {
        Request request = ContextHelper.getRequest((Context)_context);
        return (String)request.getAttribute("workspaceName");
    }

    protected static String getWorkspacePrefix() {
        Request request = ContextHelper.getRequest((Context)_context);
        return (String)request.getAttribute("workspaceURI");
    }

    public static Object config(String id) {
        if (Config.getInstance() != null) {
            return Config.getInstance().getValue(id);
        }
        return null;
    }

    public static String requestParameter(String parameter) {
        Request request = ContextHelper.getRequest((Context)_context);
        return request.getParameter(parameter);
    }

    public static String translate(String key) {
        return AmetysXSLTHelper.translate(key, null, null);
    }

    public static String translate(String key, String lang) {
        return AmetysXSLTHelper.translate(key, lang, null);
    }

    public static String translate(String key, String lang, NodeList parameters) {
        ArrayList<String> i18nparams = new ArrayList<String>();
        if (parameters != null && parameters.getLength() == 1) {
            NodeList childNodes = parameters.item(0).getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                i18nparams.add(childNodes.item(i).getTextContent());
            }
        }
        I18nizableText i18nKey = new I18nizableText(null, key, i18nparams);
        return _i18nUtils.translate(i18nKey, lang);
    }

    public static String escapeJS(String str) {
        return StringEscapeUtils.escapeEcmaScript((String)str);
    }

    public static String escapeURLforCSS(String url) {
        Map<String, String> escapeMap = Map.of("'", "\\'", "\"", "\\\"", "(", "\\(", ")", "\\)");
        return new LookupTranslator(escapeMap).translate((CharSequence)url);
    }

    public static String splitText(String textToSplit, String tokenizers, int startIndex) {
        String tokenizableText = textToSplit.substring(startIndex != 0 ? startIndex - 1 : 0, textToSplit.length());
        int tokenPlace = StringUtils.indexOfAny((CharSequence)tokenizableText, (String)tokenizers);
        if (tokenPlace == -1) {
            return textToSplit;
        }
        return textToSplit.substring(0, startIndex - 1 + tokenPlace);
    }

    @Deprecated
    public static String splitText(String textToSplit, String tokenizers, int maxCharacters, int currentCharactersNumber) {
        int tokenStartIndex = maxCharacters - currentCharactersNumber - 1;
        String tokenizableText = textToSplit.substring(tokenStartIndex, textToSplit.length());
        int tokenPlace = StringUtils.indexOfAny((CharSequence)tokenizableText, (String)tokenizers);
        if (tokenPlace == -1) {
            return textToSplit;
        }
        return textToSplit.substring(0, tokenStartIndex + tokenPlace);
    }

    public static Node versions() {
        HashMap versionsMap = new HashMap();
        ArrayList versionList = new ArrayList();
        for (Version version : _versionHandler.getVersions()) {
            HashMap<String, String> versionMap = new HashMap<String, String>();
            String componentName = version.getName();
            String componentVersion = version.getVersion();
            String componentDate = DateUtils.dateToString(version.getDate());
            if (StringUtils.isNotEmpty((CharSequence)componentName)) {
                versionMap.put("Name", componentName);
            }
            if (StringUtils.isNotEmpty((CharSequence)componentVersion)) {
                versionMap.put("Version", componentVersion);
            }
            if (StringUtils.isNotEmpty((CharSequence)componentDate)) {
                versionMap.put("Date", componentDate);
            }
            versionList.add(versionMap);
        }
        versionsMap.put("Component", versionList);
        return new MapElement("Versions", versionsMap);
    }

    public static boolean isDeveloperMode() {
        Request request = ContextHelper.getRequest((Context)_context);
        DevMode.DEVMODE developerMode = DevMode.getDeveloperMode(request);
        return developerMode == DevMode.DEVMODE.DEVELOPMENT || developerMode == DevMode.DEVMODE.SUPER_DEVELOPPMENT;
    }

    public static Node user() throws SAXException {
        UserIdentity userIdentity = _currentUserProvider.getUser();
        if (userIdentity != null) {
            return AmetysXSLTHelper.user(userIdentity.getLogin(), userIdentity.getPopulationId());
        }
        return null;
    }

    public static Node user(String userIdentity) throws SAXException {
        UserIdentity userIdentityObject = UserIdentity.stringToUserIdentity(userIdentity);
        if (userIdentityObject == null) {
            return null;
        }
        return AmetysXSLTHelper.user(userIdentityObject.getLogin(), userIdentityObject.getPopulationId());
    }

    public static Node user(String login, String populationId) throws SAXException {
        DOMBuilder domBuilder = new DOMBuilder();
        UserIdentity userIdentity = new UserIdentity(login, populationId);
        _userHelper.saxUserIdentity(userIdentity, (ContentHandler)domBuilder);
        return domBuilder.getDocument();
    }

    public static Node userByMail(String email, String populationId) throws SAXException {
        try {
            User user = _userManager.getUserByEmail(populationId, email);
            if (user != null) {
                return AmetysXSLTHelper.user(UserIdentity.userIdentityToString(user.getIdentity()));
            }
        }
        catch (NotUniqueUserException e) {
            return null;
        }
        return null;
    }

    public static NodeList groups() {
        UserIdentity userIdentity = _currentUserProvider.getUser();
        return userIdentity != null ? AmetysXSLTHelper.groups(userIdentity.getLogin(), userIdentity.getPopulationId()) : null;
    }

    public static NodeList groups(String userIdentity) {
        UserIdentity userIdentityObject = UserIdentity.stringToUserIdentity(userIdentity);
        if (userIdentityObject == null) {
            return null;
        }
        return AmetysXSLTHelper.groups(userIdentityObject.getLogin(), userIdentityObject.getPopulationId());
    }

    public static NodeList groups(String login, String populationId) {
        ArrayList<StringElement> groups = new ArrayList<StringElement>();
        Set<GroupIdentity> userGroups = _groupManager.getUserGroups(new UserIdentity(login, populationId));
        for (GroupIdentity groupId : userGroups) {
            Group group = _groupManager.getGroup(groupId);
            if (group == null) continue;
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("name", groupId.getId());
            attributes.put("directory", groupId.getDirectoryId());
            groups.add(new StringElement("group", attributes, group.getLabel()));
        }
        return new AmetysNodeList(groups);
    }

    public static String getValueFromJsonObject(String jsonString, String key) {
        block4: {
            try {
                Map<String, Object> jsonMap = _jsonUtils.convertJsonToMap(jsonString);
                if (!jsonMap.containsKey(key)) break block4;
                Object value = jsonMap.get(key);
                if (value instanceof Map || value instanceof Collection) {
                    _LOGGER.warn("Unable to get string value for key '{}' from json object {}: the value can not be a map nor collection", (Object)key, (Object)jsonString);
                    break block4;
                }
                if (value instanceof Date) {
                    return DateUtils.dateToString((Date)value);
                }
                return value.toString();
            }
            catch (Exception e) {
                _LOGGER.warn("Unable to parse json object {}", (Object)jsonString, (Object)e);
            }
        }
        return "";
    }

    public static boolean hasRight(String rightId, String objectCtx) {
        return _rightManager.currentUserHasRight(rightId, objectCtx) == RightManager.RightResult.RIGHT_ALLOW;
    }

    public static boolean isPluginEnabled(String plugin) {
        return PluginsManager.getInstance().getPluginNames().contains(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pluginImageBase64(String plugin, String path) throws MalformedURLException, IOException {
        Source source = null;
        try {
            source = _sourceResolver.resolveURI("plugin:" + plugin + "://resources/" + path);
            String string = AmetysXSLTHelper._getResourceBase64(source);
            return string;
        }
        finally {
            if (source != null) {
                _sourceResolver.release(source);
            }
        }
    }

    protected static String _getResourceBase64(Source source) {
        if (source.exists()) {
            String string;
            block9: {
                InputStream dataIs = source.getInputStream();
                try {
                    string = ImageResolverHelper.resolveImageAsBase64(dataIs, source.getMimeType(), 0, 0, 0, 0);
                    if (dataIs == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (dataIs != null) {
                            try {
                                dataIs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                dataIs.close();
            }
            return string;
        }
        return "";
    }

    public boolean pluginAvailable(String pluginName) {
        return PluginsManager.getInstance().getPluginLocation(pluginName) != null;
    }
}

