/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.util.Collection;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.runtime.i18n.I18nizableText;

public interface Cacheable {
    public Collection<SingleCacheConfiguration> getManagedCaches();

    default public boolean isCachingEnabled() {
        return true;
    }

    public AbstractCacheManager getCacheManager();

    default public <K, V> Cache<K, V> getCache(String cacheId) {
        return this.getCacheManager().get(cacheId);
    }

    default public void createCaches() {
        if (this.isCachingEnabled()) {
            for (SingleCacheConfiguration cacheConfig : this.getManagedCaches()) {
                this._createCache(cacheConfig._id, cacheConfig._label, cacheConfig._description);
            }
        }
    }

    private void _createCache(String id, I18nizableText label, I18nizableText description) {
        this.getCacheManager().createMemoryCache(id, label, description, this.hasComputableSize(), null);
    }

    default public void removeCaches() {
        if (this.isCachingEnabled()) {
            for (SingleCacheConfiguration cacheConfig : this.getManagedCaches()) {
                this.getCacheManager().removeCache(cacheConfig._id, AbstractCacheManager.CacheType.MEMORY);
            }
        }
    }

    default public boolean hasComputableSize() {
        return true;
    }

    public static final class SingleCacheConfiguration {
        private String _id;
        private I18nizableText _label;
        private I18nizableText _description;

        private SingleCacheConfiguration(String id, I18nizableText label, I18nizableText description) {
            this._id = id;
            this._label = label;
            this._description = description;
        }

        public static SingleCacheConfiguration of(String id, I18nizableText label, I18nizableText description) {
            return new SingleCacheConfiguration(id, label, description);
        }
    }
}

