/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

public class CachedValue<T> {
    private static final Object __ALL_CACHES_ONLY_KEY = new Object();
    private LoadingCache<Object, T> _loadingCache;

    CachedValue(Supplier<T> supplier, Duration expiryDuration, Ticker ticker) {
        LoadingCache loadingCache;
        this._loadingCache = loadingCache = this._cacheBuilder(expiryDuration, ticker).build(CachedValue._cacheLoader(supplier));
    }

    public static <T> CachedValue<T> withInitial(Supplier<T> supplier) {
        return new CachedValue<T>(supplier, null, null);
    }

    public static <T> CachedValue<T> withExpiryDuration(Supplier<T> supplier, Duration expiryDuration) {
        return new CachedValue<T>(supplier, expiryDuration, null);
    }

    CacheBuilder<Object, Object> _cacheBuilder(Duration expiryDuration, Ticker ticker) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().initialCapacity(1).weakKeys();
        if (expiryDuration != null) {
            cacheBuilder.expireAfterWrite(expiryDuration);
        }
        if (ticker != null) {
            cacheBuilder.ticker(ticker);
        }
        return cacheBuilder;
    }

    private static <T> CacheLoader<Object, T> _cacheLoader(final Supplier<T> supplier) {
        return new CacheLoader<Object, T>(){

            public T load(Object key) throws Exception {
                Object value = supplier.get();
                if (value == null) {
                    throw new IllegalArgumentException("The given supplier cannot return a null value.");
                }
                return value;
            }
        };
    }

    public T get() {
        try {
            return (T)this._loadingCache.get(__ALL_CACHES_ONLY_KEY);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("An unexpected error occured when loading the value from the supplier function.", e);
        }
    }

    public void uncache() {
        this._loadingCache.invalidate(__ALL_CACHES_ONLY_KEY);
    }
}

