/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;

public class CachingComponent<K, V>
extends AbstractLogEnabled
implements Initializable,
Disposable {
    private Map<K, V> _objects = new HashMap();
    private Timer _timer;

    public void initialize() throws Exception {
        if (this.isCacheEnabled()) {
            this._timer = new Timer("CachingComponent", true);
            long period = 86400000L;
            this._timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    CachingComponent.this.clearCache();
                }
            }, period, period);
        }
    }

    public void dispose() {
        if (this._timer != null) {
            this._timer.cancel();
        }
    }

    protected V getObjectFromCache(K key) {
        V object = this._objects.get(key);
        this.getLogger().debug("Getting object {} from cache for key {}", object, key);
        return object;
    }

    protected void addObjectInCache(K key, V object) {
        this.getLogger().debug("Adding object {} in cache for key {}", object, key);
        this._objects.put(key, object);
    }

    protected void removeObjectFromCache(K key) {
        this.getLogger().debug("Removing object in cache for key {}", key);
        this._objects.remove(key);
    }

    protected void clearCache() {
        this.getLogger().debug("Clearing cache");
        this._objects.clear();
    }

    protected boolean isCacheEnabled() {
        return true;
    }
}

