/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.codec.digest.Sha2Crypt;
import org.apache.commons.lang3.StringUtils;

public class CryptoHelper
extends AbstractLogEnabled
implements Component,
Configurable {
    private static final String CIPHER_ALGORITHM = "AES";
    private static final String KEY_ALGORITHM = "AES";
    private static final String PASS_HASH_ALGORITHM = "SHA-256";
    private String _cryptoKey;
    private String _filename;

    public void configure(Configuration configuration) throws ConfigurationException {
        this._filename = this._configureFilename(configuration);
    }

    protected String _configureFilename(Configuration configuration) throws ConfigurationException {
        return configuration.getChild("filename").getValue();
    }

    protected String _getFilename() {
        return this._filename;
    }

    public String decrypt(String encryptedValue, String key) throws WrongKeyException {
        byte[] data;
        Cipher cipher;
        if (encryptedValue == null) {
            return null;
        }
        try {
            cipher = this._buildCipher(key, 2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] encryptedData = Base64.getDecoder().decode(encryptedValue);
        try {
            data = cipher.doFinal(encryptedData);
        }
        catch (Exception e) {
            throw new WrongKeyException(e);
        }
        return new String(data, StandardCharsets.UTF_8);
    }

    public String decrypt(String encryptedValue) {
        String key = this.getCryptoKey();
        return this.decrypt(encryptedValue, key);
    }

    public String encrypt(String data, String key) {
        if (data == null) {
            return null;
        }
        try {
            Cipher cipher = this._buildCipher(key, 1);
            byte[] dataToSend = data.getBytes(StandardCharsets.UTF_8);
            byte[] encryptedData = cipher.doFinal(dataToSend);
            return Base64.getEncoder().encodeToString(encryptedData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String encrypt(String data) {
        String key = this.getCryptoKey();
        return this.encrypt(data, key);
    }

    public String getCryptoKey() {
        if (this._cryptoKey == null) {
            File cryptoFile = new File(AmetysHomeHelper.getAmetysHomeConfig(), this._filename);
            if (cryptoFile.exists()) {
                if (cryptoFile.canRead()) {
                    try (BufferedReader reader = new BufferedReader(new FileReader(cryptoFile));){
                        String line = reader.readLine();
                        this._cryptoKey = !StringUtils.isEmpty((CharSequence)line) ? line.trim() : this._writeKeyInFile(cryptoFile);
                    }
                    catch (IOException e) {
                        this.getLogger().error("Unable to read the crypto key from file {}", (Object)cryptoFile.getAbsolutePath(), (Object)e);
                    }
                } else {
                    this.getLogger().error("Unable to read the crypto key from file {}", (Object)cryptoFile.getAbsolutePath());
                }
            } else {
                try {
                    this._cryptoKey = this._writeKeyInFile(cryptoFile);
                }
                catch (IOException e) {
                    this.getLogger().error("Unable to write the crypto key in file {}", (Object)cryptoFile.getAbsolutePath(), (Object)e);
                }
            }
        }
        return this._cryptoKey;
    }

    protected String _writeKeyInFile(File file) throws IOException {
        try (FileWriter fw = new FileWriter(file);){
            String basePassword = ZonedDateTime.now().toString();
            String key = Sha2Crypt.sha256Crypt((byte[])basePassword.getBytes());
            fw.write(key);
            String string = key;
            return string;
        }
    }

    private Cipher _buildCipher(String password, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES");
        Key key = this._buildKey(password);
        cipher.init(mode, key);
        return cipher;
    }

    private Key _buildKey(String password) throws NoSuchAlgorithmException {
        MessageDigest digester = MessageDigest.getInstance(PASS_HASH_ALGORITHM);
        digester.update(String.valueOf(password).getBytes(StandardCharsets.UTF_8));
        byte[] key = digester.digest();
        return new SecretKeySpec(key, "AES");
    }

    public static class WrongKeyException
    extends RuntimeException {
        WrongKeyException(Exception e) {
            super(e);
        }
    }
}

