/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class DateUtils {
    public static final String ISO_OFFSET_DATE_TIME_PATTERN = "uuuu-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final DateTimeFormatter __ISO_OFFSET_DATE_TIME = DateUtils._createFormatter("uuuu-MM-dd'T'HH:mm:ss.SSSXXX");

    private DateUtils() {
    }

    private static DateTimeFormatter _createFormatter(String pattern) throws IllegalArgumentException {
        return DateTimeFormatter.ofPattern(pattern).withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    }

    public static Instant asInstant(Date date) {
        return Optional.ofNullable(date).map(Date::toInstant).orElse(null);
    }

    public static ZonedDateTime asZonedDateTime(Date date) {
        return DateUtils.asZonedDateTime(date, null);
    }

    public static ZonedDateTime asZonedDateTime(Date date, ZoneId zone) {
        return DateUtils.asZonedDateTime(DateUtils.asInstant(date), zone);
    }

    public static ZonedDateTime asZonedDateTime(Calendar calendar) {
        return DateUtils.asZonedDateTime(calendar.toInstant(), (ZoneId)ZoneOffset.UTC);
    }

    public static ZonedDateTime asZonedDateTime(long epochMilli) {
        return DateUtils.asZonedDateTime(epochMilli, null);
    }

    public static ZonedDateTime asZonedDateTime(long epochMilli, ZoneId zone) {
        Instant instant = Instant.ofEpochMilli(epochMilli);
        return DateUtils.asZonedDateTime(instant, zone);
    }

    public static ZonedDateTime asZonedDateTime(LocalDate localDate, ZoneId zone) {
        Date date = DateUtils.asDate(localDate, zone);
        return DateUtils.asZonedDateTime(date);
    }

    public static ZonedDateTime asZonedDateTime(Instant instant) {
        return DateUtils.asZonedDateTime(instant, null);
    }

    public static ZonedDateTime asZonedDateTime(Instant instant, ZoneId zone) {
        return Optional.ofNullable(instant).map(i -> i.atZone(Optional.ofNullable(zone).orElse(ZoneOffset.UTC))).orElse(null);
    }

    public static LocalDate asLocalDate(Date date, ZoneId zone) {
        return DateUtils.asZonedDateTime(date, zone).toLocalDate();
    }

    public static LocalDate asLocalDate(Date date) {
        return DateUtils.asLocalDate(date, null);
    }

    public static LocalDate asLocalDate(Calendar calendar) {
        return LocalDate.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static LocalDate asLocalDate(long epochMilli) {
        return DateUtils.asLocalDate(epochMilli, null);
    }

    public static LocalDate asLocalDate(long epochMilli, ZoneId zone) {
        Instant instant = Instant.ofEpochMilli(epochMilli);
        return DateUtils.asLocalDate(instant, zone);
    }

    public static LocalDate asLocalDate(Instant instant) {
        return DateUtils.asLocalDate(instant, null);
    }

    public static LocalDate asLocalDate(Instant instant, ZoneId zone) {
        return LocalDate.ofInstant(instant, Optional.ofNullable(zone).orElse(ZoneOffset.UTC));
    }

    public static Date asDate(LocalDate localDate) {
        return DateUtils.asDate(localDate, ZoneOffset.UTC);
    }

    public static Date asDate(LocalDate localDate, ZoneId zone) {
        return Optional.ofNullable(localDate).map(ld -> ld.atStartOfDay(Optional.ofNullable(zone).orElse(ZoneOffset.UTC))).map(ChronoZonedDateTime::toInstant).map(Date::from).orElse(null);
    }

    public static Date asDate(ZonedDateTime zonedDateTime) {
        return Date.from(zonedDateTime.toInstant());
    }

    public static Calendar asCalendar(ZonedDateTime zonedDateTime) {
        ZonedDateTime dateTimeOnDefaultZone = zonedDateTime.withZoneSameInstant(ZoneOffset.UTC);
        return GregorianCalendar.from(dateTimeOnDefaultZone);
    }

    public static Calendar asCalendar(LocalDate localDate) {
        ZonedDateTime zdt = localDate.atStartOfDay(ZoneOffset.UTC);
        return GregorianCalendar.from(zdt);
    }

    public static String formatDuration(Duration duration) {
        return DateUtils.formatDuration(duration.toMillis());
    }

    public static String formatDuration(long duration) {
        boolean showSeconds;
        StringBuilder sb = new StringBuilder();
        long durationCopy = duration;
        long ms = durationCopy % 1000L;
        long s = (durationCopy /= 1000L) % 60L;
        long m = (durationCopy /= 60L) % 60L;
        long h = (durationCopy /= 60L) % 24L;
        boolean showDays = (durationCopy /= 24L) > 0L;
        boolean showHours = showDays || h > 0L;
        boolean showMinuts = showHours || m > 0L;
        boolean bl = showSeconds = showMinuts || s > 0L;
        if (showDays) {
            sb.append(durationCopy);
            sb.append("j ");
        }
        if (showHours) {
            sb.append(DateUtils.formatNumber(h, 2));
            sb.append("h ");
        }
        if (showMinuts) {
            sb.append(DateUtils.formatNumber(m, 2));
            sb.append("m ");
        }
        if (showSeconds) {
            sb.append(DateUtils.formatNumber(s, 2));
            sb.append("s ");
        }
        sb.append(DateUtils.formatNumber(ms, 3));
        sb.append("ms");
        return sb.toString();
    }

    private static String formatNumber(long number, int nbNumbers) {
        Object numberFormatted = String.valueOf(number);
        while (((String)numberFormatted).length() < nbNumbers) {
            numberFormatted = "0" + (String)numberFormatted;
        }
        return numberFormatted;
    }

    public static DateTimeFormatter getISODateTimeFormatter() {
        return __ISO_OFFSET_DATE_TIME;
    }

    public static String dateToString(Date value) {
        if (value == null) {
            return null;
        }
        ZonedDateTime zdt = DateUtils.asZonedDateTime(value, null);
        return DateUtils.zonedDateTimeToString(zdt);
    }

    public static String epochMilliToString(long epochMilli) {
        ZonedDateTime zdt = DateUtils.asZonedDateTime(epochMilli, (ZoneId)ZoneOffset.UTC);
        return DateUtils.zonedDateTimeToString(zdt);
    }

    public static String zonedDateTimeToString(ZonedDateTime zonedDateTime, ZoneId zoneId) {
        ZonedDateTime sameInstantAtZone = zonedDateTime.withZoneSameInstant(zoneId);
        return DateUtils.zonedDateTimeToString(sameInstantAtZone);
    }

    public static String zonedDateTimeToString(ZonedDateTime zonedDateTime) {
        return zonedDateTime.format(DateUtils.getISODateTimeFormatter());
    }

    public static String zonedDateTimeToString(ZonedDateTime zonedDateTime, ZoneId zoneId, String pattern) throws IllegalArgumentException {
        ZonedDateTime sameInstantAtZone = zonedDateTime.withZoneSameInstant(zoneId);
        DateTimeFormatter formatter = DateUtils._createFormatter(pattern);
        return sameInstantAtZone.format(formatter);
    }

    public static String localDateToString(LocalDate localDate) {
        return localDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String localDateToString(LocalDate localDate, String pattern) throws IllegalArgumentException {
        DateTimeFormatter formatter = DateUtils._createFormatter(pattern);
        return localDate.format(formatter);
    }

    public static Date parse(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        ZonedDateTime zdt = ZonedDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME);
        return DateUtils.asDate(zdt);
    }

    public static ZonedDateTime parseZonedDateTime(String zonedDateTimeAsString) {
        return DateUtils.parseZonedDateTime(zonedDateTimeAsString, Optional.empty());
    }

    public static ZonedDateTime parseZonedDateTime(String zonedDateTimeAsString, String pattern) throws IllegalArgumentException {
        DateTimeFormatter formatter = DateUtils._createFormatter(pattern);
        return DateUtils.parseZonedDateTime(zonedDateTimeAsString, Optional.of(formatter));
    }

    public static ZonedDateTime parseZonedDateTime(String zonedDateTimeAsString, Optional<DateTimeFormatter> formatter) {
        if (StringUtils.isEmpty((CharSequence)zonedDateTimeAsString)) {
            return null;
        }
        return ZonedDateTime.parse(zonedDateTimeAsString, formatter.orElse(DateTimeFormatter.ISO_DATE_TIME));
    }

    public static LocalDate parseLocalDate(String localDateAsString) {
        return DateUtils.parseLocalDate(localDateAsString, Optional.empty());
    }

    public static LocalDate parseLocalDate(String localDateAsString, String pattern) throws IllegalArgumentException {
        DateTimeFormatter formatter = DateUtils._createFormatter(pattern);
        return DateUtils.parseLocalDate(localDateAsString, Optional.of(formatter));
    }

    public static LocalDate parseLocalDate(String localDateAsString, Optional<DateTimeFormatter> formatter) {
        if (StringUtils.isEmpty((CharSequence)localDateAsString)) {
            return null;
        }
        return LocalDate.parse(localDateAsString, formatter.orElse(DateTimeFormatter.ISO_LOCAL_DATE));
    }

    public static boolean isAtMidnight(String zonedDateTimeAsString, String zoneId) {
        ZonedDateTime zonedDateTime = DateUtils.parseZonedDateTime(zonedDateTimeAsString);
        zonedDateTime = zonedDateTime.withZoneSameInstant(StringUtils.isEmpty((CharSequence)zoneId) ? ZoneId.systemDefault() : ZoneId.of(zoneId));
        return zonedDateTime.getHour() == 0 && zonedDateTime.getMinute() == 0;
    }
}

