/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import org.ametys.core.util.URIUtils;

public final class FilenameUtils {
    public static final char REPLACEMENT_CHAR = '_';
    private static Predicate<Character> _isReserved = c -> ';' == c.charValue() || '\\' == c.charValue() || '/' == c.charValue() || '?' == c.charValue() || ':' == c.charValue() || '*' == c.charValue() || '|' == c.charValue() || '\"' == c.charValue() || '<' == c.charValue() || '>' == c.charValue();

    private FilenameUtils() {
    }

    public static String encodePath(String path) {
        return FilenameUtils._encodePath(path, Predicate.not(_isReserved.or(c -> '%' == c.charValue())).or(c -> '/' == c.charValue()), true);
    }

    public static String encodeName(String name) {
        return FilenameUtils._encodePath(name, Predicate.not(_isReserved.or(c -> '%' == c.charValue())), true);
    }

    public static String filterPath(String path) {
        return FilenameUtils._encodePath(path, Predicate.not(_isReserved).or(c -> '/' == c.charValue()), false);
    }

    public static String filterName(String name) {
        return FilenameUtils._encodePath(name, Predicate.not(_isReserved), false);
    }

    private static String _encodePath(String path, Predicate<Character> charactersToKeep, boolean encode) {
        char[] chars;
        StringBuilder result = new StringBuilder();
        for (char c : chars = path.toCharArray()) {
            if (charactersToKeep.test(Character.valueOf(c))) {
                result.append(c);
                continue;
            }
            if (encode) {
                byte[] bytes;
                for (byte b : bytes = String.valueOf(c).getBytes(StandardCharsets.UTF_8)) {
                    if (b < 0) {
                        b = (byte)(b + 256);
                    }
                    result.append('%');
                    char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                    char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                    result.append(hex1);
                    result.append(hex2);
                }
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }

    public static String decode(String source) {
        return URIUtils.decode(source);
    }
}

