/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import org.ametys.core.ui.Callable;
import org.apache.avalon.framework.component.Component;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils
implements Component {
    public static final String ROLE = HttpUtils.class.getName();
    public static final Pattern HTTP_URL_VALIDATOR = Pattern.compile("^(https?:\\/\\/.+)?$");
    public static final int HTTP_REDIRECT_TEMP = 307;
    public static final int HTTP_REDIRECT_PERM = 308;
    private static Logger __logger = LoggerFactory.getLogger(HttpUtils.class);

    public static HttpURLConnection prepareConnection(String url, String userAgent, String method, int timeout, int readTimeOut, boolean followRedirects) throws MalformedURLException, IOException {
        return HttpUtils.prepareConnection(url, userAgent, method, timeout, readTimeOut, followRedirects, (Map<String, String>)Collections.EMPTY_MAP);
    }

    public static HttpURLConnection prepareConnection(String httpUrl, String userAgent, String method, int timeout, int readTimeOut, boolean followRedirects, Map<String, String> requestHeaders) throws MalformedURLException, IOException {
        try {
            return HttpUtils.prepareConnection(new URI(httpUrl).toURL(), userAgent, method, timeout, readTimeOut, followRedirects, requestHeaders);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static HttpURLConnection prepareConnection(URL url, String userAgent, String method, int timeout, int readTimeOut, boolean followRedirects, Map<String, String> requestHeaders) throws MalformedURLException, IOException {
        HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
        if (userAgent != null) {
            httpUrlConnection.setRequestProperty("User-Agent", userAgent);
        }
        if (method != null) {
            httpUrlConnection.setRequestMethod(method);
        }
        if (timeout != -1) {
            httpUrlConnection.setConnectTimeout(timeout);
        }
        if (readTimeOut != -1) {
            httpUrlConnection.setReadTimeout(readTimeOut);
        }
        if (followRedirects) {
            httpUrlConnection.setInstanceFollowRedirects(true);
        }
        for (Map.Entry<String, String> headers : requestHeaders.entrySet()) {
            httpUrlConnection.setRequestProperty(headers.getKey(), headers.getValue());
        }
        return httpUrlConnection;
    }

    public static HttpCheckReport checkHttpUrl(String httpUrl, String userAgent, String method, int timeout, int readTimeOut, boolean followRedirects) {
        return HttpUtils.checkHttpUrl(httpUrl, userAgent, method, timeout, readTimeOut, followRedirects, (Map<String, String>)Collections.EMPTY_MAP);
    }

    public static HttpCheckReport checkHttpUrl(String httpUrl, String userAgent, String method, int timeout, int readTimeOut, boolean followRedirects, Map<String, String> requestHeaders) {
        if (!HTTP_URL_VALIDATOR.matcher(StringUtils.defaultIfEmpty((CharSequence)httpUrl, (CharSequence)"")).matches()) {
            __logger.debug("Url '{}' is not a valid HTTP url", (Object)httpUrl);
            return new HttpCheckReport(HttpCheck.NOT_HTTP);
        }
        try {
            return HttpUtils.checkHttpUrl(new URI(httpUrl).toURL(), userAgent, method, timeout, readTimeOut, followRedirects, requestHeaders);
        }
        catch (MalformedURLException | URISyntaxException e) {
            __logger.debug("Unable to parse '{}' as a HTTP url", (Object)httpUrl, (Object)e);
            return new HttpCheckReport(HttpCheck.NOT_HTTP);
        }
    }

    public static HttpCheckReport checkHttpUrl(URL url, String userAgent, String method, int timeout, int readTimeOut, boolean followRedirects, Map<String, String> requestHeaders) {
        return HttpUtils._checkHttpUrl(url, userAgent, method, timeout, readTimeOut, followRedirects, requestHeaders, new ArrayList<String>(), 5);
    }

    private static HttpCheckReport _checkHttpUrl(URL url, String userAgent, String method, int timeout, int readTimeOut, boolean followRedirects, Map<String, String> requestHeaders, List<String> visitedUrl, int maxRedirects) {
        try {
            HttpURLConnection connection = HttpUtils.prepareConnection(url, userAgent, method, timeout, readTimeOut, followRedirects, requestHeaders);
            if (connection.getResponseCode() == 200) {
                __logger.debug("Check of URL '{}' successed", (Object)url);
                return new HttpCheckReport(HttpCheck.SUCCESS);
            }
            if (connection.getResponseCode() == 302 || connection.getResponseCode() == 301 || connection.getResponseCode() == 303 || connection.getResponseCode() == 307 || connection.getResponseCode() == 308) {
                if (followRedirects) {
                    if (maxRedirects < 0 || visitedUrl.contains(url.toExternalForm())) {
                        throw new IOException("Exceed max number of redirects");
                    }
                    visitedUrl.add(url.toExternalForm());
                    URL base = connection.getURL();
                    String location = connection.getHeaderField("Location");
                    URL redirect = base.toURI().resolve(location).toURL();
                    return HttpUtils._checkHttpUrl(redirect, userAgent, method, timeout, readTimeOut, true, requestHeaders, visitedUrl, maxRedirects - 1);
                }
                return new HttpCheckReport(HttpCheck.REDIRECT);
            }
            __logger.debug("Check of URL '{}' returns the status code {}", (Object)url, (Object)connection.getResponseCode());
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 404: {
                    return new HttpCheckReport(HttpCheck.NOT_FOUND);
                }
                case 401: 
                case 403: {
                    return new HttpCheckReport(HttpCheck.UNAUTHORIZED);
                }
            }
            return new HttpCheckReport(HttpCheck.SERVER_ERROR, Optional.ofNullable(connection.getResponseMessage()));
        }
        catch (SSLHandshakeException e) {
            __logger.debug("Certificate error for URL '{}'", (Object)url, (Object)e);
            return new HttpCheckReport(HttpCheck.SECURITY_LEVEL_ERROR, Optional.ofNullable(e.getMessage()));
        }
        catch (SocketTimeoutException e) {
            __logger.debug("Aborting test for URL '{}' because too long", (Object)url, (Object)e);
            return new HttpCheckReport(HttpCheck.TIMEOUT);
        }
        catch (UnknownHostException e) {
            __logger.debug("Unknown host for URL '{}'", (Object)url, (Object)e);
            return new HttpCheckReport(HttpCheck.NOT_FOUND);
        }
        catch (IOException | URISyntaxException e) {
            __logger.debug("Cannot test URL '{}'", (Object)url, (Object)e);
            return new HttpCheckReport(HttpCheck.SERVER_ERROR, Optional.ofNullable(e.getMessage()));
        }
    }

    @Callable(rights={"*"})
    public Map<String, Object> checkHttpUrl(String httpUrl) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HttpCheckReport report = HttpUtils.checkHttpUrl(httpUrl, null, null, 2000, 2000, true);
        result.put("success", HttpCheck.SUCCESS.equals((Object)report.status()));
        if (report.message().isPresent()) {
            result.put("message", report.message().get());
        }
        result.put("checkResult", report.status().name());
        return result;
    }

    public static CloseableHttpClient createHttpClient(int maxConnections, int timeout) {
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(timeout > 0 ? Timeout.ofSeconds((long)timeout) : null).setSocketTimeout(timeout > 0 ? Timeout.ofSeconds((long)timeout) : null).build();
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connectionConfig).setMaxConnTotal(maxConnections > 0 ? maxConnections : 25).setMaxConnPerRoute(maxConnections > 0 ? maxConnections : 5).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).useSystemProperties().build();
    }

    public static String sanitize(String uri) {
        return StringUtils.stripEnd((String)RegExUtils.removePattern((CharSequence)uri, (String)"[^/]*.html$"), (String)"/");
    }

    public record HttpCheckReport(HttpCheck status, Optional<String> message) {
        public HttpCheckReport(HttpCheck result) {
            this(result, Optional.empty());
        }
    }

    public static enum HttpCheck {
        SUCCESS,
        SERVER_ERROR,
        NOT_FOUND,
        UNAUTHORIZED,
        TIMEOUT,
        REDIRECT,
        SECURITY_LEVEL_ERROR,
        NOT_HTTP;

    }
}

