/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.DevMode;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.cocoon.XMLResourceBundle;
import org.ametys.core.util.LambdaUtils;
import org.ametys.core.util.language.LocaleHelper;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.runtime.i18n.FormatableI18nizable;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.workspace.WorkspaceManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.i18n.Bundle;
import org.apache.cocoon.i18n.BundleFactory;
import org.apache.cocoon.xml.ParamSaxBuffer;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class I18nUtils
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable,
Initializable {
    public static final String ROLE = I18nUtils.class.getName();
    public static final String I18N_CACHE = I18nUtils.class.getName() + "$i18n";
    public static final String APPLICATION = "application";
    public static final String MESSAGES = "messages";
    protected Map<String, Location> _locations;
    protected Context _context;
    protected SourceResolver _resolver;
    private BundleFactory _bundleFactory;
    private AbstractCacheManager _cacheManager;
    private LocaleHelper _localeHelper;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._bundleFactory = (BundleFactory)manager.lookup(BundleFactory.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._localeHelper = (LocaleHelper)manager.lookup(LocaleHelper.ROLE);
    }

    public void initialize() throws Exception {
        this._createCache();
        this._configure();
    }

    protected void _createCache() {
        this._cacheManager.createMemoryCache(I18N_CACHE, new I18nizableText("plugin.core", "PLUGINS_CORE_I18N_CACHE_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_I18N_CACHE_DESCRIPTION"), true, null);
    }

    protected void _configure() {
        this._locations = new HashMap<String, Location>();
        this._locations.put(APPLICATION, new Location(APPLICATION, new String[]{this.getApplicationCatalogLocation()}));
        for (String name : this.getParamsFoldersWithI18n()) {
            this._locations.put("param." + name, new Location(MESSAGES, new String[]{this.getParamCatalogLocation(name)}));
        }
        String type = "plugin";
        PluginsManager pm = PluginsManager.getInstance();
        for (String pluginName : pm.getPluginNames()) {
            this._locations.put(type + "." + pluginName, new Location(MESSAGES, new String[]{this.getOverridableCatalogLocation(type, pluginName), this.getDefaultCatalogLocation(type, pluginName)}));
        }
        type = "workspace";
        WorkspaceManager wm = WorkspaceManager.getInstance();
        for (String workspace : wm.getWorkspaceNames()) {
            this._locations.put(type + "." + workspace, new Location(MESSAGES, new String[]{this.getOverridableCatalogLocation(type, workspace), this.getDefaultCatalogLocation(type, workspace)}));
        }
    }

    public String getApplicationCatalogLocation() {
        return "context://WEB-INF/i18n";
    }

    public String getParamCatalogLocation(String name) {
        return "context://WEB-INF/param/" + name + "/i18n";
    }

    public String getDefaultCatalogLocation(String type, String name) {
        return type + ":" + name + "://i18n";
    }

    public String getOverridableCatalogLocation(String type, String name) {
        return "context://WEB-INF/i18n/" + type + "s/" + name;
    }

    public List<String> getParamsFoldersWithI18n() {
        try {
            Source paramsRootFolder = this._resolver.resolveURI("context://WEB-INF/param");
            if (paramsRootFolder.exists() && paramsRootFolder instanceof TraversableSource) {
                Collection children = ((TraversableSource)paramsRootFolder).getChildren();
                return children.stream().filter(TraversableSource.class::isInstance).map(TraversableSource.class::cast).filter(s -> s.isCollection()).filter(LambdaUtils.wrapPredicate(s -> s.getChild("i18n").exists())).map(s -> s.getName()).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            this.getLogger().error("Error while fetching i18n folders in WEB-INF/param/*/i18n", (Throwable)e);
        }
        return List.of();
    }

    public void reloadCatalogues() {
        this.clearCache();
        this._configure();
    }

    public String translate(I18nizable text) {
        return this.translate(text, null);
    }

    public String translate(I18nizable text, String language) throws IllegalStateException {
        return this.translate(text, language, false);
    }

    public String translate(I18nizable i18nizable, String language, boolean rawValue) throws IllegalStateException {
        String langCode;
        if (language != null) {
            langCode = language;
        } else {
            Map objectModel = ContextHelper.getObjectModel((Context)this._context);
            Locale locale = this._localeHelper.findLocale(objectModel);
            langCode = locale.toString();
        }
        if (i18nizable instanceof FormatableI18nizable) {
            return ((FormatableI18nizable)i18nizable).format(LocaleUtils.toLocale((String)langCode));
        }
        I18nizableText text = (I18nizableText)i18nizable;
        String value = null;
        value = rawValue ? this._translate(text, langCode, true) : (DevMode.getDeveloperMode() != DevMode.DEVMODE.PRODUCTION ? this._translate(text, langCode, false) : this._getI18NCache().get(I18nKey.of(langCode, text), __ -> this._translate(text, langCode, false)));
        return value;
    }

    public void clearCache() {
        this._getI18NCache().invalidateAll();
    }

    protected String _translate(I18nizableText text, String language, boolean rawValue) throws IllegalStateException {
        if (!text.isI18n()) {
            return text.getLabel();
        }
        Location location = null;
        if (text.getLocation() != null) {
            location = new Location(text.getBundleName(), new String[]{text.getLocation()});
        } else {
            String catalogue = text.getCatalogue();
            location = this._locations.get(catalogue);
        }
        if (location == null) {
            return null;
        }
        try {
            ParamSaxBuffer buffer;
            Bundle bundle = this._bundleFactory.select(location.getLocations(), location.getName(), org.apache.cocoon.i18n.I18nUtils.parseLocale((String)language));
            ParamSaxBuffer paramSaxBuffer = buffer = rawValue ? (ParamSaxBuffer)((XMLResourceBundle)bundle).getRawObject(text.getKey()) : (ParamSaxBuffer)bundle.getObject(text.getKey());
            if (buffer == null) {
                return null;
            }
            HashMap<String, SaxBuffer> params = new HashMap<String, SaxBuffer>();
            if (text.getParameters() != null) {
                int p = 0;
                for (String param : text.getParameters()) {
                    SaxBuffer.Characters characters = new SaxBuffer.Characters(param.toCharArray(), 0, param.length());
                    params.put(String.valueOf(p++), new SaxBuffer(Arrays.asList(characters)));
                }
            }
            if (text.getParameterMap() != null) {
                for (String name : text.getParameterMap().keySet()) {
                    SaxBuffer.Characters characters;
                    String param;
                    I18nizableTextParameter i18nizable = text.getParameterMap().get(name);
                    if (i18nizable instanceof FormatableI18nizable) {
                        param = ((FormatableI18nizable)((Object)i18nizable)).format(LocaleUtils.toLocale((String)language));
                        characters = new SaxBuffer.Characters(param.toCharArray(), 0, param.length());
                        params.put(name, new SaxBuffer(Arrays.asList(characters)));
                        continue;
                    }
                    param = this.translate((I18nizableText)i18nizable, language, rawValue);
                    if (param == null) {
                        param = "";
                    }
                    characters = new SaxBuffer.Characters(param.toCharArray(), 0, param.length());
                    params.put(name, new SaxBuffer(Arrays.asList(characters)));
                }
            }
            StringBuilder result = new StringBuilder();
            buffer.toSAX((ContentHandler)new BufferHandler(this, result), params);
            return result.toString();
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to get i18n translation", e);
        }
        catch (ComponentException e) {
            throw new RuntimeException("Unable to get i18n catalogue", e);
        }
    }

    protected Cache<I18nKey, String> _getI18NCache() {
        return this._cacheManager.get(I18N_CACHE);
    }

    protected static class Location {
        String[] _loc;
        String _name;

        public Location(String name, String[] locations) {
            this._name = name;
            this._loc = locations;
        }

        public String getName() {
            return this._name;
        }

        public String[] getLocations() {
            return this._loc;
        }
    }

    static final class I18nKey
    extends AbstractCacheKey {
        private I18nKey(String language, I18nizableText text) {
            super(language, text);
        }

        static I18nKey of(String language, I18nizableText text) {
            return new I18nKey(language, text);
        }
    }

    private class BufferHandler
    extends DefaultHandler {
        StringBuilder _builder;

        public BufferHandler(I18nUtils i18nUtils, StringBuilder builder) {
            this._builder = builder;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this._builder.append(ch, start, length);
        }
    }
}

