/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class I18nizableSerializer
extends StdSerializer<I18nizable>
implements Component,
Serviceable,
LogEnabled,
Contextualizable {
    public static final String REQUEST_ATTR_LOCALE = "locale";
    public static final String ROLE = I18nizableSerializer.class.getName();
    private I18nUtils _i18nUtils;
    private Logger _logger;
    private Context _context;

    public I18nizableSerializer() {
        super(I18nizable.class);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._i18nUtils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    public void serialize(I18nizable i18nizable, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (i18nizable instanceof I18nizableText) {
            I18nizableText value = (I18nizableText)i18nizable;
            if (value.isI18n()) {
                String msg = this._i18nUtils.translate(value, this._getLangCode());
                if (msg == null) {
                    if (this._logger.isWarnEnabled()) {
                        this._logger.warn("Translation not found for key " + value.getKey() + " in catalogue " + value.getCatalogue());
                    }
                    jgen.writeString(value.getCatalogue() + ":" + value.getKey());
                } else {
                    jgen.writeString(msg);
                }
            } else {
                jgen.writeString(value.getLabel());
            }
        } else {
            jgen.writeString(this._i18nUtils.translate(i18nizable, this._getLangCode()));
        }
    }

    private String _getLangCode() {
        Request request = ContextHelper.getRequest((Context)this._context);
        return request != null ? (String)request.getAttribute(REQUEST_ATTR_LOCALE) : null;
    }
}

