/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import net.coobird.thumbnailator.resizers.DefaultResizerFactory;
import net.coobird.thumbnailator.tasks.io.InputStreamImageSource;
import net.coobird.thumbnailator.tasks.io.OutputStreamImageSink;
import org.apache.commons.io.IOUtils;

public final class ImageHelper {
    private static final float IMAGE_QUALITY = 0.9f;

    private ImageHelper() {
    }

    private static boolean _needsChanges(int height, int width, int maxHeight, int maxWidth, int cropHeight, int cropWidth) {
        return height > 0 || width > 0 || maxHeight > 0 || maxWidth > 0 || cropHeight > 0 || cropWidth > 0;
    }

    public static BufferedImage read(InputStream is) throws IOException {
        InputStreamImageSource imageSource = new InputStreamImageSource(is);
        ThumbnailParameter param = new ThumbnailParameter(1.0, 1.0, null, true, null, null, 1.0f, 0, null, DefaultResizerFactory.getInstance(), true, true);
        imageSource.setThumbnailParameter(param);
        BufferedImage src = imageSource.read();
        for (ImageFilter filter : param.getImageFilters()) {
            src = filter.apply(src);
        }
        return src;
    }

    public static void generateThumbnail(InputStream is, OutputStream os, String format, int height, int width, int maxHeight, int maxWidth, int cropHeight, int cropWidth) throws IOException {
        BufferedImage src;
        if (!ImageHelper._needsChanges(height, width, maxHeight, maxWidth, cropHeight, cropWidth)) {
            IOUtils.copy((InputStream)is, (OutputStream)os);
            return;
        }
        byte[] data = IOUtils.toByteArray((InputStream)is);
        BufferedImage dest = src = ImageHelper.read(new ByteArrayInputStream(data));
        if (cropHeight > 0 || cropWidth > 0) {
            dest = ImageHelper._cropImage(dest, cropHeight, cropWidth);
        }
        if (height > 0 || width > 0 || maxHeight > 0 || maxWidth > 0) {
            dest = ImageHelper._resizeImage(dest, height, width, maxHeight, maxWidth);
        }
        if (src == dest) {
            IOUtils.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)os);
            return;
        }
        OutputStreamImageSink imageSink = new OutputStreamImageSink(os);
        imageSink.setOutputFormatName(format);
        ThumbnailParameter param = new ThumbnailParameter(1.0, 1.0, null, true, null, null, 0.9f, 0, null, DefaultResizerFactory.getInstance(), true, true);
        imageSink.setThumbnailParameter(param);
        imageSink.write(dest);
    }

    public static BufferedImage generateThumbnail(BufferedImage src, int height, int width, int maxHeight, int maxWidth, int cropHeight, int cropWidth) throws IOException {
        BufferedImage dest = src;
        if (cropHeight > 0 || cropWidth > 0) {
            dest = ImageHelper._cropImage(src, cropHeight, cropWidth);
        }
        if (height > 0 || width > 0 || maxHeight > 0 || maxWidth > 0) {
            dest = ImageHelper._resizeImage(src, height, width, maxHeight, maxWidth);
        }
        return dest;
    }

    public static void generateThumbnail(InputStream is, OutputStream os, String format, int height, int width, int maxHeight, int maxWidth) throws IOException {
        ImageHelper.generateThumbnail(is, os, format, height, width, maxHeight, maxWidth, 0, 0);
    }

    public static BufferedImage generateThumbnail(BufferedImage src, int height, int width, int maxHeight, int maxWidth) throws IOException {
        return ImageHelper._resizeImage(src, height, width, maxHeight, maxWidth);
    }

    public static void generateThumbnail(InputStream is, OutputStream os, String format, double ratio) throws IOException {
        if (ratio == 1.0) {
            IOUtils.copy((InputStream)is, (OutputStream)os);
            return;
        }
        BufferedImage src = ImageHelper.read(is);
        BufferedImage dest = ImageHelper._resizeImage(src, ratio);
        OutputStreamImageSink imageSink = new OutputStreamImageSink(os);
        imageSink.setOutputFormatName(format);
        ThumbnailParameter param = new ThumbnailParameter(1.0, 1.0, null, true, null, null, 0.9f, 0, null, DefaultResizerFactory.getInstance(), true, true);
        imageSink.setThumbnailParameter(param);
        imageSink.write(dest);
    }

    public static BufferedImage generateThumbnail(BufferedImage src, double ratio) throws IOException {
        return ImageHelper._resizeImage(src, ratio);
    }

    public static void generateCroppedImage(InputStream is, OutputStream os, String format, int x, int y, int height, int width) throws IOException {
        BufferedImage src = ImageHelper.read(is);
        BufferedImage dest = ImageHelper._cropImage(src, x, y, height, width);
        OutputStreamImageSink imageSink = new OutputStreamImageSink(os);
        imageSink.setOutputFormatName(format);
        ThumbnailParameter param = new ThumbnailParameter(1.0, 1.0, null, true, null, null, 0.9f, 0, null, DefaultResizerFactory.getInstance(), true, true);
        imageSink.setThumbnailParameter(param);
        imageSink.write(dest);
    }

    public static BufferedImage generateCroppedImage(BufferedImage src, int height, int width) throws IOException {
        return ImageHelper._cropImage(src, height, width);
    }

    public static BufferedImage generateCroppedImage(BufferedImage src, int x, int y, int height, int width) throws IOException {
        return ImageHelper._cropImage(src, x, y, height, width);
    }

    protected static BufferedImage _cropImage(BufferedImage src, int height, int width) throws IOException {
        return Thumbnails.of((BufferedImage[])new BufferedImage[]{src}).size(width, height).crop((Position)Positions.CENTER).asBufferedImage();
    }

    protected static BufferedImage _cropImage(BufferedImage src, int x, int y, int height, int width) throws IOException {
        return Thumbnails.of((BufferedImage[])new BufferedImage[]{src}).scale(1.0).sourceRegion(x, y, width, height).asBufferedImage();
    }

    protected static BufferedImage _resizeImage(BufferedImage src, int height, int width, int maxHeight, int maxWidth) throws IOException {
        int srcHeight = src.getHeight();
        int srcWidth = src.getWidth();
        int destHeight = 0;
        int destWidth = 0;
        boolean keepAspectRatio = true;
        if (height > 0) {
            destHeight = height;
            if (width > 0) {
                destWidth = width;
                keepAspectRatio = false;
            } else {
                destWidth = srcWidth * destHeight / srcHeight;
            }
        } else if (width > 0) {
            destWidth = width;
            destHeight = srcHeight * destWidth / srcWidth;
        } else if (maxHeight > 0) {
            if (maxWidth > 0) {
                if (srcHeight <= maxHeight && srcWidth <= maxWidth) {
                    return src;
                }
                destWidth = maxWidth;
                destHeight = maxHeight;
            } else {
                if (srcHeight <= maxHeight) {
                    return src;
                }
                destHeight = maxHeight;
                destWidth = srcWidth * destHeight / srcHeight;
            }
        } else if (maxWidth > 0) {
            if (srcWidth <= maxWidth) {
                return src;
            }
            destWidth = maxWidth;
            destHeight = srcHeight * destWidth / srcWidth;
        } else {
            return src;
        }
        if (destHeight == srcHeight && destWidth == srcWidth) {
            return src;
        }
        return Thumbnails.of((BufferedImage[])new BufferedImage[]{src}).size(destWidth, destHeight).keepAspectRatio(keepAspectRatio).imageType(src.getColorModel().hasAlpha() ? 2 : 1).asBufferedImage();
    }

    protected static BufferedImage _resizeImage(BufferedImage src, double ratio) throws IOException {
        if (ratio == 1.0) {
            return src;
        }
        return Thumbnails.of((BufferedImage[])new BufferedImage[]{src}).scale(ratio).imageType(src.getColorModel().hasAlpha() ? 2 : 1).asBufferedImage();
    }
}

