/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ametys.core.util.ImageHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public final class ImageResolverHelper {
    private ImageResolverHelper() {
    }

    public static final String resolveImageAsBase64(InputStream dataIs, String mimeType, int height, int width, int maxHeight, int maxWidth) throws IOException {
        return ImageResolverHelper.resolveImageAsBase64(dataIs, mimeType, height, width, maxHeight, maxWidth, 0, 0);
    }

    public static final String resolveImageAsBase64(InputStream dataIs, String mimeType, int height, int width, int maxHeight, int maxWidth, int cropHeight, int cropWidth) throws IOException {
        if (!Strings.CS.startsWith((CharSequence)mimeType, (CharSequence)"image/")) {
            return "";
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (height == 0 && width == 0 && maxHeight == 0 && maxWidth == 0 && cropHeight == 0 && cropWidth == 0) {
            IOUtils.copy((InputStream)dataIs, (OutputStream)buffer);
        } else {
            String format = StringUtils.substringAfter((String)mimeType, (String)"/");
            ImageHelper.generateThumbnail(dataIs, buffer, format, height, width, maxHeight, maxWidth, cropHeight, cropWidth);
        }
        String data = Base64.encodeBase64String((byte[])buffer.toByteArray());
        return "data:" + mimeType + ";base64," + data;
    }
}

