/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.util.LambdaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarFSManager {
    private static JarFSManager _instance;
    private Map<String, FileSystem> _openedFS = new HashMap<String, FileSystem>();
    private Logger _logger = LoggerFactory.getLogger(this.getClass());

    private JarFSManager() {
    }

    public static JarFSManager getInstance() {
        if (_instance == null) {
            _instance = new JarFSManager();
        }
        return _instance;
    }

    public FileSystem getFileSystemByResource(String resourcePath) throws IOException {
        String uri = this.getJARFileURI(resourcePath);
        return this.getFileSystemByURI(uri);
    }

    public FileSystem getFileSystemByFile(File jarFile) throws IOException {
        String uri = "jar:" + jarFile.getCanonicalFile().toURI().toString();
        return this.getFileSystemByURI(uri);
    }

    public String getJARFileURI(String resourcePath) throws IOException {
        URL resource = this.getClass().getClassLoader().getResource(resourcePath);
        if (resource == null) {
            return null;
        }
        URLConnection connection = resource.openConnection();
        URL jarFileURL = ((JarURLConnection)connection).getJarFileURL();
        return "jar:" + jarFileURL.toString();
    }

    public synchronized FileSystem getFileSystemByURI(String jarURI) throws IOException {
        if (jarURI == null) {
            return null;
        }
        try {
            this._logger.debug("Opening the jar at uri: {}", (Object)jarURI);
            return this._openedFS.computeIfAbsent(jarURI, LambdaUtils.wrap(u -> FileSystems.newFileSystem(new URI((String)u), Collections.emptyMap())));
        }
        catch (LambdaUtils.LambdaException e) {
            if (e.getCause() instanceof NoSuchFileException) {
                this._logger.error("Could not find the jar at uri: {}", (Object)jarURI);
            }
            throw (IOException)e.getCause();
        }
    }
}

