/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;

public final class LambdaUtils {
    private LambdaUtils() {
    }

    public static <T, R> Function<T, R> wrap(ThrowingFunction<T, R> function) {
        return value -> {
            try {
                return function.apply(value);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new LambdaException(e);
            }
        };
    }

    public static <T> Predicate<T> wrapPredicate(ThrowingPredicate<T> predicate) {
        return LambdaUtils.wrap(predicate::test)::apply;
    }

    public static <T> Consumer<T> wrapConsumer(ThrowingConsumer<T> consumer) {
        return value -> {
            try {
                consumer.accept(value);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new LambdaException(e);
            }
        };
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingPredicate<T> {
        public boolean test(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T>
    extends ThrowingConsumerExceptionAware<T, Exception> {
    }

    public static class LambdaException
    extends RuntimeException {
        public LambdaException(Throwable cause) {
            super(cause);
        }
    }

    public static class BiPredicate<T, U> {
        public static <T, U> java.util.function.BiPredicate<T, U> not(java.util.function.BiPredicate<? super T, ? super U> target) {
            Objects.requireNonNull(target);
            return target.negate();
        }
    }

    public static class Collectors {
        public static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
            return java.util.stream.Collectors.toMap(keyMapper, valueMapper, Collectors._throwingMerger(), LinkedHashMap::new);
        }

        private static <T> BinaryOperator<T> _throwingMerger() {
            return (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            };
        }

        public static <T, R> Collector<T, List<T>, R> withListAccumulation(Function<List<T>, R> finisher) {
            return Collector.of(ArrayList::new, (res, q) -> res.add(q), (res1, res2) -> {
                res1.addAll(res2);
                return res1;
            }, finisher, new Collector.Characteristics[0]);
        }
    }

    @FunctionalInterface
    public static interface ThrowingConsumerExceptionAware<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

