/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MapUtils {
    private static BinaryOperator<?> __DEFAULT_MERGE_FUNCTION = (value1, value2) -> value1;

    private MapUtils() {
    }

    private static <V> BinaryOperator<V> _defaultMergeFunction() {
        return __DEFAULT_MERGE_FUNCTION;
    }

    public static <K, V> Map<K, V> merge(Map<? extends K, ? extends V> map1, Map<? extends K, ? extends V> map2) {
        Stream<Map<? extends K, ? extends V>> sequentialStreamOfMaps = Stream.of(map1, map2);
        return MapUtils._merge(MapUtils._defaultMergeFunction(), sequentialStreamOfMaps);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> merge(Map<? extends K, ? extends V> map1, Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> ... others) {
        return MapUtils.merge(MapUtils._defaultMergeFunction(), map1, map2, others);
    }

    public static <K, V> Map<K, V> merge(BinaryOperator<V> mergeFunction, Map<? extends K, ? extends V> map1, Map<? extends K, ? extends V> map2) {
        Stream<Map<? extends K, ? extends V>> sequentialStreamOfMaps = Stream.of(map1, map2);
        return MapUtils._merge(mergeFunction, sequentialStreamOfMaps);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> merge(BinaryOperator<V> mergeFunction, Map<? extends K, ? extends V> map1, Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> ... others) {
        Stream sequentialStreamOfMaps = (Stream)Stream.of(Stream.of(map1, map2), Stream.of(others)).flatMap(stream -> stream).sequential();
        return MapUtils._merge(mergeFunction, sequentialStreamOfMaps);
    }

    private static <K, V> Map<K, V> _merge(BinaryOperator<V> mergeFunction, Stream<Map<? extends K, ? extends V>> sequentialStreamOfMaps) {
        return sequentialStreamOfMaps.map(Map::entrySet).map(ArrayList::new).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction));
    }

    public static Object deepMerge(Object value1, Object value2) {
        if (value1 instanceof Map && value2 instanceof Map) {
            HashMap firstMap = new HashMap((Map)value1);
            HashMap secondMap = new HashMap((Map)value2);
            for (Object key : secondMap.keySet()) {
                Object value = secondMap.get(key);
                if (value != null) {
                    firstMap.merge(key, value, MapUtils::deepMerge);
                    continue;
                }
                if (firstMap.containsKey(key)) continue;
                firstMap.put(key, value);
            }
            return firstMap;
        }
        return value1;
    }
}

