/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.disableconditions.DefaultDisableConditionsEvaluator;
import org.ametys.runtime.model.disableconditions.DisableConditionsEvaluator;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.runtime.model.type.xml.XMLElementType;
import org.ametys.runtime.parameter.ValidationResult;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ReadUsersAndGroupsDataHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = ReadUsersAndGroupsDataHelper.class.getName();
    protected DisableConditionsEvaluator _disableConditionsEvaluator;

    public void service(ServiceManager manager) throws ServiceException {
        this._disableConditionsEvaluator = (DisableConditionsEvaluator)manager.lookup(DefaultDisableConditionsEvaluator.ROLE);
    }

    public Map<String, Object> readAndValidateXMLData(Configuration configuration, String prefix, Map<String, ? extends ElementDefinition> definitions, Map<String, List<I18nizableText>> allErrors) throws ConfigurationException {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (String dataName : definitions.keySet()) {
            ElementDefinition definition = definitions.get(dataName);
            ModelItemType type = definition.getType();
            if (!(type instanceof XMLElementType)) continue;
            XMLElementType xmlElementType = (XMLElementType)type;
            Object value = xmlElementType.read(configuration, dataName);
            values.put(prefix + dataName, value);
        }
        HashMap<String, Object> contextualParametersForDisableConditions = new HashMap<String, Object>();
        contextualParametersForDisableConditions.put("definitions", definitions);
        contextualParametersForDisableConditions.put("prefix", prefix);
        LinkedHashMap<String, Object> xmlValues = new LinkedHashMap<String, Object>();
        for (String dataName : definitions.keySet()) {
            ElementDefinition definition = definitions.get(dataName);
            boolean isDisabled = this._disableConditionsEvaluator.evaluateDisableConditions(definition, definition.getName(), Optional.empty(), values, null, contextualParametersForDisableConditions);
            Object value = values.get(prefix + dataName);
            if (!isDisabled) {
                ValidationResult validationResult = ModelHelper.validateValue(definition, value);
                if (!validationResult.hasErrors()) {
                    xmlValues.put(dataName, value);
                    continue;
                }
                allErrors.put(dataName, validationResult.getErrors());
                continue;
            }
            xmlValues.put(dataName, value);
        }
        return xmlValues;
    }
}

