/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.FieldData;
import org.openjdk.jol.layouters.CurrentLayouter;
import org.openjdk.jol.util.ObjectUtils;
import org.openjdk.jol.vm.VM;
import org.slf4j.LoggerFactory;

public final class SizeUtils {
    private static Map<Class<?>, Pair<Long, List<Field>>> __cache = new ConcurrentHashMap();

    private SizeUtils() {
    }

    public static boolean enabled() {
        try {
            VM.current();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static long sizeOf(Object object) {
        if (object == null) {
            return 0L;
        }
        try {
            return SizeUtils._sizeOf(object, Collections.newSetFromMap(new IdentityHashMap()));
        }
        catch (Error e) {
            LoggerFactory.getLogger((String)SizeUtils.class.getName()).error("Error computing size of {}", object, (Object)e);
            throw e;
        }
    }

    private static long _sizeOf(Object object, Set<Object> visited) {
        if (!visited.add(object)) {
            return 0L;
        }
        if (object instanceof Sized) {
            Sized sized = (Sized)object;
            return sized.getSize();
        }
        Class<?> klass = object.getClass();
        if (klass.isArray()) {
            Object[] array;
            long size = new CurrentLayouter().layout(ClassData.parseInstance((Object)object)).instanceSize();
            if (klass.getComponentType().isPrimitive()) {
                return size;
            }
            for (Object item : array = (Object[])object) {
                if (!SizeUtils._isComputable(item)) continue;
                size += SizeUtils._sizeOf(item, visited);
            }
            return size;
        }
        Pair<Long, List<Field>> data = SizeUtils._shallowSizeOf(klass);
        long size = (Long)data.getLeft();
        for (Field field : (List)data.getRight()) {
            Object value = ObjectUtils.value((Object)object, (Field)field);
            if (!SizeUtils._isComputable(value)) continue;
            size += SizeUtils._sizeOf(value, visited);
        }
        return size;
    }

    private static Pair<Long, List<Field>> _shallowSizeOf(Class<?> klass) {
        return __cache.computeIfAbsent(klass, c -> {
            ClassData classData = ClassData.parseClass((Class)c);
            ArrayList<Field> fields = new ArrayList<Field>();
            for (FieldData fieldData : classData.fields()) {
                Field field = fieldData.refField();
                if (field.getType().isPrimitive() || field.isAnnotationPresent(ExcludeFromSizeCalculation.class)) continue;
                fields.add(field);
            }
            return Pair.of((Object)new CurrentLayouter().layout(classData).instanceSize(), fields);
        });
    }

    public static long shallowSizeOf(Object object) {
        Class<?> klass = object.getClass();
        Pair<Long, List<Field>> data = SizeUtils._shallowSizeOf(klass);
        return (Long)data.getKey();
    }

    public static long totalSizeOf(Object ... objects) {
        long size = 0L;
        if (objects != null) {
            for (Object object : objects) {
                size += SizeUtils.sizeOf(object);
            }
        }
        return size;
    }

    private static boolean _isComputable(Object object) {
        return object != null && !(object instanceof Class);
    }

    static {
        System.setProperty("jol.magicFieldOffset", "true");
        Object.class.getModule().getPackages().forEach(p -> {
            if (Object.class.getModule().isOpen((String)p, ObjectUtils.class.getModule())) {
                Object.class.getModule().addOpens((String)p, ObjectUtils.class.getModule());
            }
        });
    }

    public static interface Sized {
        public long getSize();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ExcludeFromSizeCalculation {
    }
}

