/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtils {
    private static final Logger __LOGGER = LoggerFactory.getLogger(StringUtils.class);
    private static final long __DATA_SIZE_NEXT_LIMIT = 1024L;
    private static final List<String> __DATA_SIZE_KEYS = List.of("PLUGINS_CORE_UI_FORMAT_FILE_SIZE_NOT_ESCAPED_BYTES", "PLUGINS_CORE_UI_FORMAT_FILE_SIZE_NOT_ESCAPED_KB", "PLUGINS_CORE_UI_FORMAT_FILE_SIZE_NOT_ESCAPED_MB", "PLUGINS_CORE_UI_FORMAT_FILE_SIZE_NOT_ESCAPED_GB", "PLUGINS_CORE_UI_FORMAT_FILE_SIZE_NOT_ESCAPED_TB");
    private static final String[] __CSV_BEGIN_CHARS = new String[]{"=", "@", "+", "-", "\r", "\t"};
    private static final char __CSV_QUOTE = '\"';
    private static final String __CSV_QUOTE_STR = String.valueOf('\"');

    private StringUtils() {
    }

    public static Collection<String> stringToCollection(String values) {
        ArrayList<String> result = new ArrayList<String>();
        if (values != null && values.length() > 0) {
            StringTokenizer stk = new StringTokenizer(values, ",");
            while (stk.hasMoreTokens()) {
                result.add(stk.nextToken().trim());
            }
        }
        return result;
    }

    public static String[] stringToStringArray(String values) {
        Collection<String> coll = StringUtils.stringToCollection(values);
        return coll.toArray(new String[coll.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateKey() {
        Class<StringUtils> clazz = StringUtils.class;
        synchronized (StringUtils.class) {
            long value = System.currentTimeMillis();
            try {
                Thread.sleep(15L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String longString = Long.toString(value, 36);
            return longString;
        }
    }

    public static String md5Base64(String password) {
        MessageDigest md5;
        if (password == null) {
            return null;
        }
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            __LOGGER.error("Cannot encode the password to md5Base64", (Throwable)e);
            return null;
        }
        md5.reset();
        try {
            md5.update(password.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        byte[] hash = md5.digest();
        try {
            return new String(Base64.encodeBase64((byte[])hash), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String normalizeStringValue(String value) {
        return Normalizer.normalize(value.toLowerCase(), Normalizer.Form.NFD).replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
    }

    public static I18nizableText toReadableDataSize(Long size) {
        if (size == 1L) {
            return StringUtils._createReadatableDataSize(size, "PLUGINS_CORE_UI_FORMAT_FILE_SIZE_NOT_ESCAPED_BYTE");
        }
        return StringUtils._toReadableDataSize(size, __DATA_SIZE_KEYS.iterator());
    }

    private static I18nizableText _toReadableDataSize(Long size, Iterator<String> keys) {
        String key = keys.next();
        if (!keys.hasNext() || size < 1024L) {
            return StringUtils._createReadatableDataSize(size, key);
        }
        return StringUtils._toReadableDataSize(size / 1024L, keys);
    }

    private static I18nizableText _createReadatableDataSize(Long size, String key) {
        return new I18nizableText("plugin.core-ui", key, List.of(size.toString()));
    }

    public static String escapeCsv(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)value)) {
            sb.append(Strings.CS.replace(value, __CSV_QUOTE_STR, __CSV_QUOTE_STR + __CSV_QUOTE_STR));
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String sanitizeCsv(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)value)) {
            if (Strings.CS.startsWithAny((CharSequence)value, (CharSequence[])__CSV_BEGIN_CHARS)) {
                sb.append("'");
            }
            sb.append(Strings.CS.replace(value, __CSV_QUOTE_STR, __CSV_QUOTE_STR + __CSV_QUOTE_STR));
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String sanitizeXlsHtml(String value) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)value) && Strings.CS.startsWithAny((CharSequence)value, (CharSequence[])__CSV_BEGIN_CHARS)) {
            return "'" + value;
        }
        return org.apache.commons.lang3.StringUtils.defaultString((String)value);
    }

    public static class AlphanumComparator
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            String normalizedS1 = Normalizer.normalize(s1.toLowerCase(), Normalizer.Form.NFD).replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").trim();
            String normalizedS2 = Normalizer.normalize(s2.toLowerCase(), Normalizer.Form.NFD).replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").trim();
            int s1Index = 0;
            int s2Index = 0;
            while (s1Index < normalizedS1.length() && s2Index < normalizedS2.length()) {
                char s1Char = normalizedS1.charAt(s1Index);
                char s2Char = normalizedS2.charAt(s2Index);
                if (Character.isDigit(s1Char) && Character.isDigit(s2Char)) {
                    int s1Start = s1Index;
                    int s2Start = s2Index;
                    while (s1Index < normalizedS1.length() && Character.isDigit(normalizedS1.charAt(s1Index))) {
                        ++s1Index;
                    }
                    while (s2Index < normalizedS2.length() && Character.isDigit(normalizedS2.charAt(s2Index))) {
                        ++s2Index;
                    }
                    try {
                        Long num2;
                        Long num1 = Long.parseLong(normalizedS1.substring(s1Start, s1Index));
                        if (num1 == (num2 = Long.valueOf(Long.parseLong(normalizedS2.substring(s2Start, s2Index))))) continue;
                        return (int)(num1 - num2);
                    }
                    catch (NumberFormatException e) {
                        return normalizedS1.compareTo(normalizedS2);
                    }
                }
                if (s1Char != s2Char) {
                    return s1Char - s2Char;
                }
                ++s1Index;
                ++s2Index;
            }
            return normalizedS1.length() - normalizedS2.length();
        }
    }
}

