/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.commons.lang3.LocaleUtils;

public class TimeZoneEnumerator
implements Enumerator<String>,
Serviceable,
Contextualizable {
    private UserManager _userManager;
    private CurrentUserProvider _currentUserProvider;
    private Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    private Locale _getCurrentLocale() {
        Map objectModel;
        Locale locale;
        String language;
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        User user = this._userManager.getUser(userIdentity);
        String string = language = user != null ? user.getLanguage() : null;
        if (language == null && (locale = I18nUtils.findLocale((Map)(objectModel = ContextHelper.getObjectModel((Context)this._context)), (String)"locale", null, (Locale)Locale.getDefault(), (boolean)true)) != null) {
            language = locale.getLanguage();
        }
        return LocaleUtils.toLocale((String)language);
    }

    private I18nizableText _getEntry(String value, Locale locale) {
        TimeZone timeZone = TimeZone.getTimeZone(value);
        return new I18nizableText(value + " (" + timeZone.getDisplayName(locale) + ")");
    }

    @Override
    public I18nizableText getEntry(String value) throws Exception {
        Locale locale = this._getCurrentLocale();
        return this._getEntry(value, locale);
    }

    @Override
    public Map<String, I18nizableText> getEntries() throws Exception {
        HashMap<String, I18nizableText> typedEntries = new HashMap<String, I18nizableText>();
        Locale locale = this._getCurrentLocale();
        for (String timeZoneId : TimeZone.getAvailableIDs()) {
            typedEntries.put(timeZoneId, this._getEntry(timeZoneId, locale));
        }
        return typedEntries;
    }
}

