/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Predicate;

public final class URIUtils {
    private static final String __NAME_VALUE_SEPARATOR = "=";
    private static final String __PARAMETER_SEPARATOR = "&";
    private static Predicate<Byte> _isAlpha = c -> c >= 97 && c <= 122 || c >= 65 && c <= 90;
    private static Predicate<Byte> _isDigit = c -> c >= 48 && c <= 57;
    private static Predicate<Byte> _isSubDelimiter = c -> 33 == c || 36 == c || 38 == c || 39 == c || 40 == c || 41 == c || 42 == c || 43 == c || 44 == c || 59 == c || 61 == c;
    private static Predicate<Byte> _isUnreserved = _isAlpha.or(_isDigit).or(c -> 45 == c || 46 == c || 95 == c || 126 == c);
    private static Predicate<Byte> _isPchar = _isUnreserved.or(_isSubDelimiter).or(c -> 58 == c || 64 == c);

    private URIUtils() {
    }

    public static String encodeParameter(String value) {
        return URIUtils._encodeUriComponent(value, _isPchar.or(c -> 47 == c || 63 == c).and(Predicate.not(c -> 61 == c || 43 == c || 38 == c)));
    }

    public static String encodeFragment(String value) {
        return URIUtils._encodeUriComponent(value, _isPchar.or(c -> 47 == c || 63 == c));
    }

    public static String encodePath(String path) {
        return URIUtils._encodeUriComponent(path, _isPchar.or(c -> 47 == c).and(Predicate.not(c -> 59 == c)));
    }

    public static String encodePathSegment(String pathSegment) {
        return URIUtils._encodeUriComponent(pathSegment, _isPchar.and(Predicate.not(c -> 59 == c)));
    }

    public static String encodeHeader(String header) {
        return URIUtils._encodeUriComponent(header, _isUnreserved);
    }

    private static String _encodeUriComponent(String uriComponent, Predicate<Byte> charactersToKeep) {
        byte[] bytes = uriComponent.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
        for (byte b : bytes) {
            if (b < 0) {
                b = (byte)(b + 256);
            }
            if (charactersToKeep.test(b)) {
                bos.write(b);
                continue;
            }
            bos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            bos.write(hex1);
            bos.write(hex2);
        }
        return new String(bos.toByteArray(), StandardCharsets.US_ASCII);
    }

    public static String encodeURI(String path, Map<String, String> parameters) {
        return URIUtils._buildURI(path, parameters, true);
    }

    public static String buildURI(String path, Map<String, String> parameters) {
        return URIUtils._buildURI(path, parameters, false);
    }

    private static String _buildURI(String path, Map<String, String> parameters, boolean encode) {
        StringBuilder sb = new StringBuilder();
        sb.append(encode ? URIUtils.encodePath(path) : path);
        if (parameters != null && !parameters.isEmpty()) {
            StringBuilder query = new StringBuilder();
            for (String paramName : parameters.keySet()) {
                String encodedValue;
                String encodedName = encode ? URIUtils.encodeParameter(paramName) : paramName;
                String string = encodedValue = encode ? URIUtils.encodeParameter(parameters.get(paramName)) : parameters.get(paramName);
                if (query.length() > 0) {
                    query.append(__PARAMETER_SEPARATOR);
                }
                query.append(encodedName).append(__NAME_VALUE_SEPARATOR).append(encodedValue);
            }
            sb.append("?").append(query.toString());
        }
        return sb.toString();
    }

    public static String decode(String source) {
        int length = source.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    bos.write((byte)((u << 4) + l));
                    i += 2;
                    changed = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            if (ch > '\u0000' && ch < '\u0080') {
                bos.write(ch);
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                if (i + 1 < length && Character.isLowSurrogate(source.charAt(i + 1))) {
                    for (byte b : String.valueOf(new char[]{ch, source.charAt(i + 1)}).getBytes(StandardCharsets.UTF_8)) {
                        bos.write(b);
                    }
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            for (byte b : String.valueOf(ch).getBytes(StandardCharsets.UTF_8)) {
                bos.write(b);
            }
        }
        return changed ? new String(bos.toByteArray(), StandardCharsets.UTF_8) : source;
    }
}

