/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.cocoon;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ametys.core.util.ImageHelper;
import org.ametys.core.util.URIUtils;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;

public abstract class AbstractResourceReader
extends AbstractReader {
    protected static final String __DEFAULT_FORMAT = "png";
    protected static final Collection<String> __ALLOWED_OUTPUT_FORMATS = Arrays.asList("png", "gif", "jpg", "jpeg");
    protected static final Collection<String> __UNRESIZABLE_FORMATS = Set.of("svg");
    private int _width;
    private int _height;
    private int _maxWidth;
    private int _maxHeight;
    private int _cropWidth;
    private int _cropHeight;
    private boolean _readForDownload;

    public void setup(SourceResolver sresolver, Map sObjectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(sresolver, sObjectModel, src, par);
        this.doSetup(sresolver, sObjectModel, src, par);
        this._readForDownload = par.getParameterAsBoolean("download", false);
        Response response = ObjectModelHelper.getResponse((Map)sObjectModel);
        if (this._readForDownload) {
            String name = this.getFilename();
            String encodedName = this.getEncodedFilename();
            encodedName = encodedName != null ? URIUtils.encodeHeader(encodedName) : null;
            response.setHeader("Content-Disposition", "attachment; filename=\"" + (encodedName != null ? encodedName : name) + "\"" + (String)(encodedName != null ? ";filename*=UTF-8''" + encodedName : ""));
        }
        this._width = par.getParameterAsInteger("width", 0);
        this._height = par.getParameterAsInteger("height", 0);
        this._maxWidth = par.getParameterAsInteger("maxWidth", 0);
        this._maxHeight = par.getParameterAsInteger("maxHeight", 0);
        this._cropWidth = par.getParameterAsInteger("cropWidth", 0);
        this._cropHeight = par.getParameterAsInteger("cropHeight", 0);
    }

    protected abstract void doSetup(SourceResolver var1, Map var2, String var3, Parameters var4) throws ProcessingException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
        try (InputStream is = this.getInputStream();){
            String fileExtension;
            String fileName = this.getFilename();
            int i = fileName.lastIndexOf(46);
            String string = fileExtension = i != -1 ? fileName.substring(i + 1).toLowerCase() : __DEFAULT_FORMAT;
            if (this.processImage(fileExtension)) {
                String outputFormat = __ALLOWED_OUTPUT_FORMATS.contains(fileExtension) ? fileExtension : __DEFAULT_FORMAT;
                this.generateThumbnail(is, outputFormat);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Image generated: " + ObjectModelHelper.getRequest((Map)this.objectModel).getRequestURI());
                }
            } else {
                response.setHeader("Content-Length", Long.toString(this.getLength()));
                IOUtils.copy((InputStream)is, (OutputStream)this.out);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Resource generated: " + ObjectModelHelper.getRequest((Map)this.objectModel).getRequestURI());
                }
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.out);
        }
    }

    protected void generateThumbnail(InputStream is, String format) throws IOException {
        ImageHelper.generateThumbnail(is, this.out, format, this._height, this._width, this._maxHeight, this._maxWidth, this._cropHeight, this._cropWidth);
    }

    protected abstract InputStream getInputStream();

    protected abstract String getFilename();

    protected abstract String getEncodedFilename();

    protected abstract long getLength();

    protected boolean processImage(String fileExtension) {
        if (__UNRESIZABLE_FORMATS.contains(fileExtension)) {
            return false;
        }
        if (this._width > 0 || this._height > 0 || this._maxHeight > 0 || this._maxWidth > 0 || this._cropHeight > 0 || this._cropWidth > 0) {
            return true;
        }
        if (!this._readForDownload) {
            return this.getMimeType() != null && this.getMimeType().startsWith("image/");
        }
        return false;
    }

    protected String getKeySuffix() {
        return "#" + this._height + "#" + this._width + "#" + this._maxHeight + "#" + this._maxWidth + "#" + this._cropHeight + "#" + this._cropWidth;
    }
}

