/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.date;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalUnit;
import java.util.Objects;

public final class AdaptableDate {
    private static final AdaptableDate __TODAY = new AdaptableDate(AdaptableDateType.RELATIVE_TO_TODAY, OffsetType.NOW, 0L, null);
    private static final AdaptableDate __NOW = new AdaptableDate(AdaptableDateType.RELATIVE_TO_NOW, OffsetType.NOW, 0L, null);
    private final AdaptableDateType _type;
    private final LocalDate _staticDate;
    private final LocalDateTime _staticDateTime;
    private final TemporalUnit _relativeUnit;
    private final long _relativeAmount;
    private final OffsetType _relativeOffsetType;

    private AdaptableDate(LocalDate date, LocalDateTime dateTime) {
        this._type = AdaptableDateType.STATIC;
        this._staticDate = date;
        this._staticDateTime = dateTime;
        this._relativeUnit = null;
        this._relativeAmount = 0L;
        this._relativeOffsetType = null;
    }

    private AdaptableDate(AdaptableDateType type, OffsetType offsetType, long amount, TemporalUnit unit) {
        if (type == AdaptableDateType.STATIC) {
            throw new IllegalArgumentException("There can't be any offset for a static AdaptableDate");
        }
        this._type = type;
        this._staticDate = null;
        this._staticDateTime = null;
        this._relativeUnit = unit;
        this._relativeAmount = amount;
        this._relativeOffsetType = offsetType;
    }

    public static AdaptableDate fromDateTime(LocalDateTime dateTime) {
        return new AdaptableDate(null, dateTime);
    }

    public static AdaptableDate fromDate(LocalDate date) {
        return new AdaptableDate(date, null);
    }

    public static AdaptableDate now() {
        return __NOW;
    }

    public static AdaptableDate today() {
        return __TODAY;
    }

    public static AdaptableDate past(AdaptableDateType type, long amount, TemporalUnit unit) {
        return new AdaptableDate(type, OffsetType.PAST, amount, unit);
    }

    public static AdaptableDate future(AdaptableDateType type, long amount, TemporalUnit unit) {
        return new AdaptableDate(type, OffsetType.FUTURE, amount, unit);
    }

    public DateTimeInterval resolveDateTime() {
        if (this._type == AdaptableDateType.STATIC) {
            if (this._staticDateTime != null) {
                return new DateTimeInterval(this._staticDateTime, this._staticDateTime);
            }
            LocalDateTime min = this._staticDate.atStartOfDay();
            LocalDateTime max = this._staticDate.atTime(LocalTime.MAX);
            return new DateTimeInterval(min, max);
        }
        if (this._type == AdaptableDateType.RELATIVE_TO_NOW) {
            LocalDateTime now = LocalDateTime.now();
            switch (this._relativeOffsetType.ordinal()) {
                case 0: {
                    return new DateTimeInterval(now, now);
                }
                case 1: {
                    LocalDateTime past = now.minus(this._relativeAmount, this._relativeUnit);
                    return new DateTimeInterval(past, past);
                }
            }
            LocalDateTime future = now.plus(this._relativeAmount, this._relativeUnit);
            return new DateTimeInterval(future, future);
        }
        LocalDate today = LocalDate.now();
        switch (this._relativeOffsetType.ordinal()) {
            case 0: {
                LocalDateTime min = today.atStartOfDay();
                LocalDateTime max = today.atTime(LocalTime.MAX);
                return new DateTimeInterval(min, max);
            }
            case 1: {
                LocalDate past = today.minus(this._relativeAmount, this._relativeUnit);
                LocalDateTime minPast = past.atStartOfDay();
                LocalDateTime maxPast = past.atTime(LocalTime.MAX);
                return new DateTimeInterval(minPast, maxPast);
            }
        }
        LocalDate future = today.plus(this._relativeAmount, this._relativeUnit);
        LocalDateTime minFuture = future.atStartOfDay();
        LocalDateTime maxFuture = future.atTime(LocalTime.MAX);
        return new DateTimeInterval(minFuture, maxFuture);
    }

    public LocalDate resolveDate() {
        if (this._type == AdaptableDateType.STATIC) {
            if (this._staticDate != null) {
                return this._staticDate;
            }
            return this._staticDateTime.toLocalDate();
        }
        LocalDate now = LocalDate.now();
        switch (this._relativeOffsetType.ordinal()) {
            case 0: {
                return now;
            }
            case 1: {
                return now.minus(this._relativeAmount, this._relativeUnit);
            }
        }
        return now.plus(this._relativeAmount, this._relativeUnit);
    }

    public String toString() {
        switch (this._type.ordinal()) {
            case 0: {
                return this._staticDate != null ? this._staticDate.toString() : this._staticDateTime.toString();
            }
            case 2: {
                switch (this._relativeOffsetType.ordinal()) {
                    case 0: {
                        return "Today";
                    }
                    case 1: {
                        return this._relativeAmount + " " + String.valueOf(this._relativeUnit) + " ago today";
                    }
                }
                return "Today in " + this._relativeAmount + " " + String.valueOf(this._relativeUnit);
            }
        }
        switch (this._relativeOffsetType.ordinal()) {
            case 0: {
                return "Now";
            }
            case 1: {
                return this._relativeAmount + " " + String.valueOf(this._relativeUnit) + " ago";
            }
        }
        return "In " + this._relativeAmount + " " + String.valueOf(this._relativeUnit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._type, this._staticDate, this._staticDateTime, this._relativeAmount, this._relativeOffsetType, this._relativeUnit});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AdaptableDate)) {
            return false;
        }
        AdaptableDate other = (AdaptableDate)obj;
        return Objects.equals((Object)this._type, (Object)other._type) && Objects.equals(this._staticDate, other._staticDate) && Objects.equals(this._staticDateTime, other._staticDateTime) && Objects.equals(this._relativeAmount, other._relativeAmount) && Objects.equals((Object)this._relativeOffsetType, (Object)other._relativeOffsetType) && Objects.equals(this._relativeUnit, other._relativeUnit);
    }

    public static enum AdaptableDateType {
        STATIC,
        RELATIVE_TO_NOW,
        RELATIVE_TO_TODAY;

    }

    private static enum OffsetType {
        NOW,
        PAST,
        FUTURE;

    }

    public record DateTimeInterval(LocalDateTime min, LocalDateTime max) {
    }
}

