/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.date;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.ametys.core.util.date.AdaptableDate;
import org.apache.commons.lang3.StringUtils;

public final class AdaptableDateParser {
    private static final String __SPECIAL_CHAR = "$";
    private static final String __CURRENT = "current";
    private static final String __TODAY = "today";
    private static final String __AGO = "ago$";
    private static final String __IN = "in$";
    private static final String __AGO_FULLDAY = "ago_fullday$";
    private static final String __IN_FULLDAY = "in_fullday$";

    private AdaptableDateParser() {
    }

    public static final AdaptableDate parse(String value) {
        if (value.startsWith(__SPECIAL_CHAR)) {
            String relativeDate = StringUtils.substringAfter((String)value, (String)__SPECIAL_CHAR);
            if (__CURRENT.equals(relativeDate)) {
                return AdaptableDate.now();
            }
            if (__TODAY.equals(relativeDate)) {
                return AdaptableDate.today();
            }
            if (relativeDate.startsWith(__AGO)) {
                String amountAndUnit = StringUtils.substringAfter((String)relativeDate, (String)__AGO);
                String unitStr = StringUtils.substringAfterLast((String)amountAndUnit, (String)__SPECIAL_CHAR);
                Long amount = Long.valueOf(StringUtils.substringBeforeLast((String)amountAndUnit, (String)__SPECIAL_CHAR));
                return AdaptableDate.past(AdaptableDate.AdaptableDateType.RELATIVE_TO_NOW, amount, ChronoUnit.valueOf(unitStr));
            }
            if (relativeDate.startsWith(__IN)) {
                String amountAndUnit = StringUtils.substringAfter((String)relativeDate, (String)__IN);
                String unitStr = StringUtils.substringAfterLast((String)amountAndUnit, (String)__SPECIAL_CHAR);
                Long amount = Long.valueOf(StringUtils.substringBeforeLast((String)amountAndUnit, (String)__SPECIAL_CHAR));
                return AdaptableDate.future(AdaptableDate.AdaptableDateType.RELATIVE_TO_NOW, amount, ChronoUnit.valueOf(unitStr));
            }
            if (relativeDate.startsWith(__AGO_FULLDAY)) {
                String amountAndUnit = StringUtils.substringAfter((String)relativeDate, (String)__AGO_FULLDAY);
                String unitStr = StringUtils.substringAfterLast((String)amountAndUnit, (String)__SPECIAL_CHAR);
                Long amount = Long.valueOf(StringUtils.substringBeforeLast((String)amountAndUnit, (String)__SPECIAL_CHAR));
                return AdaptableDate.past(AdaptableDate.AdaptableDateType.RELATIVE_TO_TODAY, amount, ChronoUnit.valueOf(unitStr));
            }
            if (relativeDate.startsWith(__IN_FULLDAY)) {
                String amountAndUnit = StringUtils.substringAfter((String)relativeDate, (String)__IN_FULLDAY);
                String unitStr = StringUtils.substringAfterLast((String)amountAndUnit, (String)__SPECIAL_CHAR);
                Long amount = Long.valueOf(StringUtils.substringBeforeLast((String)amountAndUnit, (String)__SPECIAL_CHAR));
                return AdaptableDate.future(AdaptableDate.AdaptableDateType.RELATIVE_TO_TODAY, amount, ChronoUnit.valueOf(unitStr));
            }
            throw new IllegalArgumentException("'" + value + "' cannot be parsed.");
        }
        if (value.indexOf(84) > 0) {
            return AdaptableDate.fromDateTime(LocalDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME));
        }
        return AdaptableDate.fromDate(LocalDate.parse(value, DateTimeFormatter.ISO_LOCAL_DATE));
    }
}

