/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.dom;

import java.util.Map;
import org.ametys.core.util.dom.AbstractAmetysNode;
import org.ametys.core.util.dom.AmetysAttribute;
import org.ametys.core.util.dom.AmetysNamedNodeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public abstract class AbstractAmetysElement
extends AbstractAmetysNode
implements Element {
    protected Element _parent;
    private Map<String, AmetysAttribute> _attsMap;
    private String _tagName;

    public AbstractAmetysElement() {
    }

    public AbstractAmetysElement(String tagName) {
        this._tagName = tagName;
    }

    public AbstractAmetysElement(Element parent) {
        this._parent = parent;
    }

    public AbstractAmetysElement(String tagName, Element parent) {
        this._tagName = tagName;
        this._parent = parent;
    }

    @Override
    public String getTagName() {
        return this._tagName;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public String getLocalName() {
        return this.getTagName();
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public Node getParentNode() {
        return this._parent;
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this._attsMap == null) {
            this._attsMap = this._lookupAttributes();
        }
        return new AmetysNamedNodeMap(this._attsMap);
    }

    @Override
    public String getAttribute(String name) {
        Attr attr;
        if (this._attsMap == null) {
            this._attsMap = this._lookupAttributes();
        }
        if ((attr = (Attr)this._attsMap.get(name)) == null || attr.getValue() == null || attr.getValue().isEmpty()) {
            return "";
        }
        return attr.getValue();
    }

    @Override
    public Attr getAttributeNode(String name) {
        if (this._attsMap == null) {
            this._attsMap = this._lookupAttributes();
        }
        return this._attsMap.get(name);
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.getAttribute(localName);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return this.getAttributeNode(localName);
    }

    @Override
    public boolean hasAttributes() {
        if (this._attsMap == null) {
            this._attsMap = this._lookupAttributes();
        }
        return !this._attsMap.isEmpty();
    }

    @Override
    public boolean hasAttribute(String name) {
        if (this._attsMap == null) {
            this._attsMap = this._lookupAttributes();
        }
        return this._attsMap.containsKey(name);
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.hasAttribute(localName);
    }

    @Override
    public String getTextContent() throws DOMException {
        StringBuilder sb = new StringBuilder();
        NodeList children = this.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            sb.append(children.item(i).getTextContent());
        }
        return sb.toString();
    }

    protected abstract Map<String, AmetysAttribute> _lookupAttributes();

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new DOMException(9, "getSchemaTypeInfo");
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        throw new DOMException(9, "getElementsByTagName");
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "getElementsByTagNameNS");
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        throw new DOMException(9, "setAttribute");
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        throw new DOMException(9, "removeAttribute");
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new DOMException(9, "setAttributeNode");
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new DOMException(9, "removeAttributeNode");
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DOMException(9, "setAttributeNS");
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "removeAttributeNS");
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DOMException(9, "setAttributeNodeNS");
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(9, "setIdAttribute");
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(9, "setIdAttributeNS");
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(9, "setIdAttributeNode");
    }
}

