/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.dom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMUtils {
    private DOMUtils() {
    }

    public static List<Element> getChildElements(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("The element must not be null");
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    public static Element getFirstChildElement(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("The element must not be null");
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static List<Element> getUniqueChildElements(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("The element must not be null");
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        HashSet<String> tagNames = new HashSet<String>();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String dataName = node.getNodeName();
            if (tagNames.contains(dataName) || node.getNodeType() != 1) continue;
            elements.add((Element)node);
            tagNames.add(dataName);
        }
        return elements;
    }

    public static List<Element> getChildElementsByTagName(Element element, String name) {
        if (element == null) {
            throw new IllegalArgumentException("The element must not be null");
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("The name must not be empty");
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !name.equals(node.getNodeName())) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    public static Element getChildElementByTagName(Element element, String name) {
        if (element == null) {
            throw new IllegalArgumentException("The element must not be null");
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("The name must not be empty");
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !name.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static boolean hasChildElement(Element element, String name) {
        return DOMUtils.getChildElementByTagName(element, name) != null;
    }
}

