/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.dom;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ametys.core.util.dom.AbstractWrappingAmetysElement;
import org.ametys.core.util.dom.AmetysAttribute;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.TraversableSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SourceElement
extends AbstractWrappingAmetysElement<Source> {
    public SourceElement(Source source) {
        this(source, null);
    }

    public SourceElement(Source source, SourceElement parent) {
        super(source, (Element)parent);
    }

    @Override
    public String getTagName() {
        return this._object instanceof TraversableSource && ((TraversableSource)this._object).isCollection() ? "collection" : "resource";
    }

    @Override
    protected Map<String, AmetysAttribute> _lookupAttributes() {
        HashMap<String, AmetysAttribute> result = new HashMap<String, AmetysAttribute>();
        result.put("name", new AmetysAttribute("name", "name", null, StringUtils.substringAfterLast((String)((Source)this._object).getURI(), (String)"/"), this));
        return result;
    }

    @Override
    public boolean hasChildNodes() {
        try {
            return this._object instanceof TraversableSource && ((TraversableSource)this._object).isCollection() && CollectionUtils.isNotEmpty((Collection)((TraversableSource)this._object).getChildren());
        }
        catch (SourceException e) {
            throw new RuntimeException("Cannot list child elements of " + ((Source)this._object).getURI(), e);
        }
    }

    @Override
    public Node getFirstChild() {
        try {
            Collection children;
            if (this._object instanceof TraversableSource && ((TraversableSource)this._object).isCollection() && (children = ((TraversableSource)this._object).getChildren()).size() > 0) {
                return new SourceElement((Source)children.iterator().next(), this);
            }
        }
        catch (SourceException e) {
            throw new RuntimeException("Cannot list child elements of " + ((Source)this._object).getURI(), e);
        }
        return null;
    }

    @Override
    public Node getNextSibling() {
        Iterator iterator;
        if (this._parent == null) {
            return null;
        }
        TraversableSource parent = (TraversableSource)((AbstractWrappingAmetysElement)this._parent).getWrappedObject();
        try {
            iterator = parent.getChildren().iterator();
        }
        catch (SourceException e) {
            throw new RuntimeException("Cannot list child elements of " + parent.getURI(), e);
        }
        boolean isNext = false;
        Source nextSibling = null;
        while (nextSibling == null && iterator.hasNext()) {
            Source child = (Source)iterator.next();
            if (isNext) {
                nextSibling = child;
                continue;
            }
            if (!((Source)this._object).getURI().equals(child.getURI())) continue;
            isNext = true;
        }
        return nextSibling == null ? null : new SourceElement(nextSibling, (SourceElement)this._parent);
    }
}

