/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.filereloader;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.util.filereloader.FileReloader;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;

public class FileReloaderUtils
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = FileReloaderUtils.class.getName();
    private static final String __FILERELOADER_CACHE = FileReloaderUtils.class.getName() + "$Cache";
    protected SourceResolver _resolver;
    private AbstractCacheManager _cacheManager;
    private Map<String, FileMetadatas> _files;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        this._files = new ConcurrentHashMap<String, FileMetadatas>();
        this._cacheManager.createRequestCache(__FILERELOADER_CACHE, new I18nizableText("plugin.core", "PLUGINS_CORE_FILERELOADER_CACHE_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_FILERELOADER_CACHE_DESCRIPTION"), true);
    }

    public void updateFile(String sourceUrl, FileReloader fileReloader) throws Exception {
        this.updateFile(sourceUrl, null, fileReloader);
    }

    public void updateFile(String sourceUrl, boolean forceRead, FileReloader fileReloader) throws Exception {
        this.updateFile(sourceUrl, null, forceRead, fileReloader);
    }

    public void updateFile(String sourceUrl, Map parameters, FileReloader fileReloader) throws Exception {
        this.updateFile(sourceUrl, parameters, false, fileReloader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFile(String sourceUrl, Map parameters, boolean forceRead, FileReloader fileReloader) throws Exception {
        FileMetadatas fileMetadatas;
        String id = fileReloader.getId(sourceUrl);
        Cache<String, String> cache = this._cacheManager.get(__FILERELOADER_CACHE);
        if (!forceRead && cache.get(id) != null) {
            return;
        }
        FileMetadatas fileMetadatas2 = fileMetadatas = this._files.computeIfAbsent(id, i -> new FileMetadatas(sourceUrl, parameters));
        synchronized (fileMetadatas2) {
            Source source;
            block16: {
                source = null;
                try {
                    source = this._resolver.resolveURI(fileMetadatas.getSourceUrl(), null, fileMetadatas.getParameters());
                    if (!source.exists()) {
                        throw new SourceNotFoundException("Source '" + fileMetadatas.getSourceUrl() + "' not found");
                    }
                    long sourceLastModified = source.getLastModified() / 1000L * 1000L;
                    if (!forceRead && sourceLastModified == fileMetadatas.getLastModified()) break block16;
                    this.getLogger().debug("Reading configuration file at {}", (Object)fileMetadatas.getSourceUrl());
                    try (InputStream is = source.getInputStream();){
                        fileReloader.updateFile(fileMetadatas.getSourceUrl(), source, is);
                        fileMetadatas.setLastModified(sourceLastModified);
                        this.getLogger().debug("Configuration file read. at {}", (Object)fileMetadatas.getSourceUrl());
                    }
                }
                catch (SourceNotFoundException e) {
                    try {
                        if (forceRead || fileMetadatas.getLastModified() != 0L) {
                            this.getLogger().debug("File at {} could not be found", (Object)fileMetadatas.getSourceUrl(), (Object)e);
                            fileReloader.updateFile(fileMetadatas.getSourceUrl(), null, null);
                        }
                        fileMetadatas.setLastModified(0L);
                    }
                    catch (Throwable throwable) {
                        this._resolver.release(source);
                        cache.put(id, id);
                        throw throwable;
                    }
                    this._resolver.release(source);
                    cache.put(id, id);
                }
            }
            this._resolver.release(source);
            cache.put(id, id);
        }
    }

    private static class FileMetadatas {
        public static final long UNKNOWN = -1L;
        public static final long FILE_DOES_NOT_EXIST = 0L;
        private long _lastModified;
        private String _sourceUrl;
        private Map _parameters;

        public FileMetadatas(String sourceUrl, Map parameters) {
            this._sourceUrl = sourceUrl;
            this._lastModified = -1L;
            this._parameters = parameters;
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public void setLastModified(long lastFileReading) {
            this._lastModified = lastFileReading;
        }

        public String getSourceUrl() {
            return this._sourceUrl;
        }

        public Map getParameters() {
            return this._parameters;
        }
    }
}

