/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.language;

import java.util.Locale;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.runtime.plugin.component.DeferredServiceable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.commons.lang3.LocaleUtils;

public class LocaleHelper
extends AbstractLogEnabled
implements Component,
DeferredServiceable {
    public static final String ROLE = LocaleHelper.class.getName();
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _userManager;
    protected UserLanguagesManager _userLanguagesManager;

    @Override
    public void deferredService(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)manager.lookup(UserLanguagesManager.ROLE);
    }

    public Locale findLocale(Map objectModel) {
        Locale locale;
        block5: {
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            locale = this.findCurrentUserLocale();
            if (locale == null) {
                locale = request.getLocale();
            }
            if (locale == null) {
                String defaultLanguage = this._userLanguagesManager.getDefaultLanguage();
                try {
                    locale = LocaleUtils.toLocale((String)defaultLanguage);
                }
                catch (IllegalArgumentException e) {
                    Logger logger = this.getLogger();
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("The default language in configuration parameter is not a valid language. Default server locale will be used", (Throwable)e);
                }
            }
        }
        if (locale == null) {
            locale = I18nUtils.findLocale((Map)objectModel, (String)"locale", null, (Locale)Locale.getDefault(), (boolean)true);
        }
        return locale;
    }

    protected Locale findCurrentUserLocale() {
        block3: {
            String language;
            User user;
            UserIdentity userIdentity = this._currentUserProvider.getUser();
            if (userIdentity != null && (user = this._userManager.getUser(userIdentity)) != null && (language = user.getLanguage()) != null) {
                try {
                    return LocaleUtils.toLocale((String)language);
                }
                catch (IllegalArgumentException e) {
                    Logger logger = this.getLogger();
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn("The user " + String.valueOf(userIdentity) + " does not have a valid language in user preferences. Default language will be used", (Throwable)e);
                }
            }
        }
        return null;
    }
}

