/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.language;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.util.language.Language;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UserLanguageEnumerator
implements Enumerator<String>,
Serviceable,
Component {
    public static final String ROLE = UserLanguageEnumerator.class.getName();
    private UserLanguagesManager _languageManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._languageManager = (UserLanguagesManager)manager.lookup(UserLanguagesManager.ROLE);
    }

    @Override
    public I18nizableText getEntry(String value) throws Exception {
        Map<String, Language> languages = this._languageManager.getAvailableLanguages();
        if (languages.containsKey(value)) {
            return languages.get(value).label();
        }
        return new I18nizableText("");
    }

    @Override
    public Map<String, I18nizableText> getEntries() throws Exception {
        HashMap<String, I18nizableText> entries = new HashMap<String, I18nizableText>();
        Map<String, Language> languages = this._languageManager.getAvailableLanguages();
        for (Language lang : languages.values()) {
            entries.put(lang.code(), lang.label());
        }
        return entries;
    }
}

