/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.language;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.language.Language;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class UserLanguagesManager
implements Configurable,
Component {
    public static final String ROLE = UserLanguagesManager.class.getName();
    private Map<String, Language> _languages;

    public void configure(Configuration configuration) throws ConfigurationException {
        this._languages = new LinkedHashMap<String, Language>();
        Configuration languagesConfiguration = configuration;
        for (Configuration lConf : languagesConfiguration.getChildren("language")) {
            String code = lConf.getAttribute("code");
            Language language = lConf.getAttributeAsBoolean("i18n", true) ? new Language(code, new I18nizableText("application", lConf.getValue(code))) : new Language(code, new I18nizableText(lConf.getValue(code)));
            this._languages.put(code, language);
        }
    }

    public Language getLanguage(String code) {
        return this._languages.get(code);
    }

    public Map<String, Language> getAvailableLanguages() {
        return this._languages;
    }

    @Callable(rights={"*"})
    public List<Map<String, Object>> getAvailableLanguagesAsJsonObject() {
        ArrayList<Map<String, Object>> availableLanguages = new ArrayList<Map<String, Object>>();
        for (Language language : this.getAvailableLanguages().values()) {
            availableLanguages.add(this.toJson(language));
        }
        return availableLanguages;
    }

    public String getDefaultLanguage() {
        Language language;
        String defaultLanguageConfigParameter;
        Config configInstance = Config.getInstance();
        if (configInstance != null && (defaultLanguageConfigParameter = (String)configInstance.getValue("runtime.language.default")) != null && (language = this._languages.get(defaultLanguageConfigParameter)) != null) {
            return language.code();
        }
        return null;
    }

    protected Map<String, Object> toJson(Language language) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("name", language.code());
        info.put("label", language.label());
        return info;
    }
}

