/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.SortControl;
import org.ametys.core.datasource.AbstractDataSourceManager;
import org.ametys.core.datasource.LDAPDataSourceManager;
import org.ametys.core.datasource.UnknownDataSourceException;
import org.ametys.core.util.ldap.IncompleteLDAPResultException;
import org.ametys.core.util.ldap.ScopeEnumerator;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public abstract class AbstractLDAPConnector
extends AbstractLogEnabled
implements Serviceable {
    protected static final int __PAGE_SIZE = 500;
    private static final Pattern __FILTER = Pattern.compile("\\s*\\(.*\\)\\s*");
    private static final String __CONNECT_TIMEOUT = "10000";
    private static final String __READ_TIMEOUT = "60000";
    protected String _ldapUrl;
    protected String _ldapBaseDN;
    protected String _ldapAdminRelativeDN;
    protected String _ldapAdminPassword;
    protected String _ldapAuthenticationMethod;
    protected boolean _ldapUseSSL;
    protected boolean _ldapFollowReferrals;
    protected String _ldapAliasDerefMode;
    protected boolean _serverSideSorting;
    protected boolean _pagingSupported;
    private LDAPDataSourceManager _ldapDataSourceManager;

    protected void _delayedInitialize(String dataSourceId) throws Exception {
        AbstractDataSourceManager.DataSourceDefinition ldapDefinition = this._ldapDataSourceManager.getDataSourceDefinition(dataSourceId);
        if (ldapDefinition != null) {
            Map<String, Object> ldapParameters = ldapDefinition.getParameters();
            this._ldapUrl = (String)ldapParameters.get("baseURL");
            this._ldapBaseDN = (String)ldapParameters.get("baseDN");
            this._ldapAdminRelativeDN = (String)ldapParameters.get("adminDN");
            this._ldapAdminPassword = (String)ldapParameters.get("adminPassword");
            this._ldapAuthenticationMethod = (String)ldapParameters.get("authenticationMethod");
            this._ldapUseSSL = (Boolean)ldapParameters.get("useSSL");
            this._ldapFollowReferrals = (Boolean)ldapParameters.get("followReferrals");
            this._ldapAliasDerefMode = (String)ldapParameters.get("aliasDereferencing");
            this._serverSideSorting = (Boolean)ldapParameters.get("serverSideSorting");
            this._pagingSupported = this._testPagingSupported();
            if (!this._testConnectionsPooled()) {
                this.getLogger().warn("Warning! LDAP connections for this connector are not pooled. If you are using SSL, you must set the system property 'com.sun.jndi.ldap.connect.pool.protocol' to the String \"plain ssl\".");
            }
        } else {
            throw new UnknownDataSourceException("The data source of id '" + dataSourceId + "' is still referenced but no longer exists.");
        }
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._ldapDataSourceManager = (LDAPDataSourceManager)serviceManager.lookup(LDAPDataSourceManager.ROLE);
    }

    protected String _getFilter(Configuration configuration, String filterKey) throws ConfigurationException {
        String filter = this._getConfigParameter(configuration, filterKey);
        if (!__FILTER.matcher(filter).matches()) {
            String message = "Invalid filter '" + filter + "', missing parenthesis";
            throw new ConfigurationException(message, configuration);
        }
        return filter;
    }

    protected int _getSearchScope(Configuration configuration, String searchScopeKey) throws ConfigurationException {
        String usersSearchScope = this._getConfigParameter(configuration, searchScopeKey);
        try {
            return ScopeEnumerator.parseScope(usersSearchScope);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Unable to parse scope", (Throwable)e);
        }
    }

    protected boolean _isPagingSupported() {
        return this._pagingSupported;
    }

    protected String _getConfigParameter(Configuration configuration, String key) throws ConfigurationException {
        String parameterName = configuration.getChild(key).getValue(null);
        if (parameterName == null) {
            String message = "The parameter '" + key + "' is missing";
            this.getLogger().error(message);
            throw new ConfigurationException(message, configuration);
        }
        String valeur = (String)Config.getInstance().getValue(parameterName);
        return valeur;
    }

    protected Hashtable<String, String> _getContextEnv() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("com.sun.jndi.ldap.connect.timeout", __CONNECT_TIMEOUT);
        env.put("com.sun.jndi.ldap.read.timeout", __READ_TIMEOUT);
        env.put("java.naming.provider.url", this._ldapUrl + "/" + this._ldapBaseDN);
        env.put("java.naming.security.authentication", this._ldapAuthenticationMethod);
        if (!this._ldapAuthenticationMethod.equals("none")) {
            env.put("java.naming.security.principal", this._ldapAdminRelativeDN);
            env.put("java.naming.security.credentials", this._ldapAdminPassword);
        }
        if (this._ldapUseSSL) {
            env.put("java.naming.security.protocol", "ssl");
        }
        if (this._ldapFollowReferrals) {
            env.put("java.naming.referral", "follow");
        } else {
            env.put("java.naming.referral", "ignore");
        }
        env.put("java.naming.ldap.derefAliases", this._ldapAliasDerefMode);
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        return env;
    }

    protected Hashtable<String, String> _getRootContextEnv() {
        Hashtable<String, String> env = this._getContextEnv();
        env.put("java.naming.provider.url", this._ldapUrl);
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _testPagingSupported() {
        boolean supported = false;
        InitialLdapContext context = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            context = new InitialLdapContext(this._getRootContextEnv(), null);
            SearchControls controls = new SearchControls();
            controls.setReturningAttributes(new String[]{"supportedControl"});
            controls.setSearchScope(0);
            results = context.search("", "(objectClass=*)", controls);
            while (results.hasMore() && !supported) {
                SearchResult entry = results.next();
                NamingEnumeration<? extends Attribute> attrs = entry.getAttributes().getAll();
                while (attrs.hasMore() && !supported) {
                    Attribute attr = attrs.next();
                    NamingEnumeration<?> vals = attr.getAll();
                    while (vals.hasMore() && !supported) {
                        String value = (String)vals.next();
                        if (!"1.2.840.113556.1.4.319".equals(value)) continue;
                        supported = true;
                    }
                }
            }
            this._cleanup(context, results);
        }
        catch (NamingException e) {
            try {
                this.getLogger().warn("Error while testing the LDAP server for paging feature, assuming false.", (Throwable)e);
                this._cleanup(context, results);
            }
            catch (Throwable throwable) {
                this._cleanup(context, results);
                throw throwable;
            }
        }
        return supported;
    }

    protected boolean _testConnectionsPooled() {
        return !this._ldapUseSSL || "plain ssl".equals(System.getProperty("com.sun.jndi.ldap.connect.pool.protocol"));
    }

    protected void _cleanup(Context context, NamingEnumeration result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (NamingException e) {
                this.getLogger().error("Error while closing ldap result", (Throwable)e);
            }
        }
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException e) {
                this.getLogger().error("Error while closing ldap connection", (Throwable)e);
            }
        }
    }

    protected List<SearchResult> _search(String name, String filter, SearchControls searchControls) throws NamingException, IncompleteLDAPResultException {
        return this._search(name, filter, null, searchControls, 0, Integer.MAX_VALUE, false);
    }

    protected List<SearchResult> _search(String name, String filter, SearchControls searchControls, boolean sorted) throws NamingException, IncompleteLDAPResultException {
        return this._search(name, filter, null, searchControls, 0, Integer.MAX_VALUE, sorted);
    }

    protected List<SearchResult> _search(String name, String filter, Object[] filterArgs, SearchControls searchControls, int offset, int limit) throws NamingException, IncompleteLDAPResultException {
        return this._search(name, filter, filterArgs, searchControls, offset, limit, false);
    }

    protected List<SearchResult> _search(String name, String filter, Object[] filterArgs, SearchControls searchControls, int offset, int limit, boolean sorted) throws NamingException, IncompleteLDAPResultException {
        ArrayList<SearchResult> allResults = new ArrayList<SearchResult>();
        InitialLdapContext context = null;
        NamingEnumeration<SearchResult> tmpResults = null;
        try {
            context = new InitialLdapContext(this._getContextEnv(), null);
            searchControls.setCountLimit(offset + limit);
            this._setResultsControls(context, sorted);
            int index = 0;
            do {
                tmpResults = context.search(name, filter, filterArgs, searchControls);
                try {
                    while (tmpResults != null && tmpResults.hasMore()) {
                        SearchResult result = tmpResults.next();
                        if (index >= offset) {
                            allResults.add(result);
                        }
                        ++index;
                    }
                }
                catch (PartialResultException e) {
                    if (this._ldapFollowReferrals) {
                        this.getLogger().warn("Error communicating with ldap server", (Throwable)e);
                        continue;
                    }
                    this.getLogger().debug("Error communicating with ldap server", (Throwable)e);
                }
            } while (this._hasMoreEntries(context));
            this._cleanup(context, tmpResults);
        }
        catch (SizeLimitExceededException e) {
            try {
                throw new IncompleteLDAPResultException(allResults, e);
            }
            catch (Throwable throwable) {
                this._cleanup(context, tmpResults);
                throw throwable;
            }
        }
        return allResults;
    }

    protected boolean _hasMoreEntries(LdapContext context) throws NamingException {
        byte[] cookie = null;
        Control[] controls = context.getResponseControls();
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[i];
                cookie = prrc.getCookie();
            }
        }
        if (this._isPagingSupported()) {
            try {
                context.setRequestControls(new Control[]{new PagedResultsControl(500, cookie, false)});
            }
            catch (IOException ioe) {
                this.getLogger().error("Error setting the PagedResultsControl in the LDAP context.", (Throwable)ioe);
            }
        }
        return cookie != null;
    }

    protected void _setResultsControls(LdapContext context, boolean sorted) throws NamingException {
        ArrayList<BasicControl> controls = new ArrayList<BasicControl>();
        if (this._isPagingSupported()) {
            try {
                controls.add(new PagedResultsControl(500, false));
            }
            catch (IOException ioe) {
                this.getLogger().error("Error setting the PagingResultsControl in the LDAP context.", (Throwable)ioe);
            }
        }
        String[] sortByFields = this.getSortByFields();
        if (sorted && sortByFields != null && sortByFields.length > 0) {
            try {
                controls.add(new SortControl(sortByFields, false));
            }
            catch (IOException ioe) {
                this.getLogger().error("Error setting the SortControl in the LDAP context.", (Throwable)ioe);
            }
        }
        if (controls.size() > 0) {
            context.setRequestControls(controls.toArray(new Control[controls.size()]));
        }
    }

    protected String[] getSortByFields() {
        return null;
    }
}

