/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.ldap;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

public class ScopeEnumerator
implements Enumerator<String> {
    private static final String __CORE_IMPL_CATALOGUE = "plugin.core-impl";
    private static final Map<String, I18nizableText> __SCOPES = new LinkedHashMap<String, I18nizableText>(3);

    public static int parseScope(String scope) throws IllegalArgumentException {
        if ("one".equals(scope)) {
            return 1;
        }
        if ("sub".equals(scope)) {
            return 2;
        }
        if ("object".equals(scope)) {
            return 0;
        }
        throw new IllegalArgumentException("Invalid scope: " + scope);
    }

    @Override
    public I18nizableText getEntry(String value) {
        return __SCOPES.get(value);
    }

    @Override
    public Map<String, I18nizableText> getEntries() {
        return __SCOPES;
    }

    static {
        __SCOPES.put("object", new I18nizableText(__CORE_IMPL_CATALOGUE, "PLUGINS_CORE_USERS_LDAPUSER_CONFIG_SEARCH_SCOPE_ENUM_OBJECT"));
        __SCOPES.put("one", new I18nizableText(__CORE_IMPL_CATALOGUE, "PLUGINS_CORE_USERS_LDAPUSER_CONFIG_SEARCH_SCOPE_ENUM_ONE"));
        __SCOPES.put("sub", new I18nizableText(__CORE_IMPL_CATALOGUE, "PLUGINS_CORE_USERS_LDAPUSER_CONFIG_SEARCH_SCOPE_ENUM_SUB"));
    }
}

