/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.mail;

import jakarta.activation.DataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.ametys.core.util.mail.SendMailHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public final class InputStreamDataSource
implements DataSource {
    private String _name;
    private String _type;
    private File _tmpFile;

    public InputStreamDataSource(SendMailHelper.NamedStream attachment) throws IOException {
        this._name = attachment.name();
        this._type = attachment.mimeType();
        String prefix = StringUtils.substringBeforeLast((String)this._name, (String)".");
        String suffix = StringUtils.substringAfterLast((String)this._name, (String)".");
        this._tmpFile = Files.createTempFile(prefix, "." + suffix, new FileAttribute[0]).toFile();
        IOUtils.copy((InputStream)attachment.inputStream(), (OutputStream)new FileOutputStream(this._tmpFile));
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._tmpFile);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("Method getOutputStream can't be called for InputStreamDataSource");
    }

    public String getContentType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public void dispose() throws IOException {
        FileUtils.forceDeleteOnExit((File)this._tmpFile);
    }
}

