/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.PreencodedMimeBodyPart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.util.mail.InputStreamDataSource;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.excalibur.source.SourceUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.jsoup.select.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SendMailHelper
implements Disposable {
    public static final String EMAIL_VALIDATION_REGEXP = "^.+@.+$";
    public static final Pattern EMAIL_VALIDATION = Pattern.compile("^.+@.+$");
    private static final Logger __LOGGER = LoggerFactory.getLogger(SendMailHelper.class);
    private static final ExecutorService __SINGLE_THREAD_EXECUTOR = Executors.newSingleThreadExecutor(new MailSenderThreadFactory());

    private SendMailHelper() {
    }

    public void dispose() {
        __SINGLE_THREAD_EXECUTOR.shutdownNow();
    }

    public static MailBuilder newMail() {
        return new MailBuilder(__LOGGER, __SINGLE_THREAD_EXECUTOR);
    }

    public static String inlineCSS(String html) {
        LinkedList<CssRule> rules = new LinkedList<CssRule>();
        Document doc = Jsoup.parse((String)html);
        Elements els = doc.select("style");
        for (Element e : els) {
            String styleRules = ((Element)e.getAllElements().get(0)).data();
            styleRules = styleRules.replaceAll("\t|\r|\n", "").replaceAll("<!--", "").replaceAll("-->", "");
            styleRules = SendMailHelper._removeComments(styleRules);
            styleRules = styleRules.trim();
            StringTokenizer st = new StringTokenizer(styleRules, "{}");
            while (st.countTokens() > 1) {
                String[] selector;
                String selectors = st.nextToken();
                String properties = st.nextToken();
                for (String s : selector = selectors.split(",")) {
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    rules.add(new CssRule(s.trim(), properties, rules.size()));
                }
            }
            e.remove();
        }
        Collections.sort(rules, Collections.reverseOrder());
        for (CssRule rule : rules) {
            try {
                Elements selectedElements = doc.select(rule.getSelector());
                Iterator iterator = selectedElements.iterator();
                while (iterator.hasNext()) {
                    Element selElem;
                    String oldProperties = (selElem = (Element)iterator.next()).attr("style");
                    selElem.attr("style", oldProperties.length() > 0 ? SendMailHelper.concatenateProperties(oldProperties, rule.getProperties()) : rule.getProperties());
                }
            }
            catch (Selector.SelectorParseException ex) {
                __LOGGER.error("Cannot inline CSS with rule \"" + rule.getSelector() + "\".Ignoring this rule and continuing.", (Throwable)ex);
            }
        }
        return doc.toString();
    }

    private static String _removeComments(String styleRules) {
        int i = styleRules.indexOf("/*");
        int j = styleRules.indexOf("*/");
        if (i >= 0 && j > i) {
            return styleRules.substring(0, i) + SendMailHelper._removeComments(styleRules.substring(j + 2));
        }
        return styleRules;
    }

    private static String concatenateProperties(String oldProp, String newProp) {
        Object between = "";
        if (!newProp.endsWith(";")) {
            between = (String)between + ";";
        }
        return newProp + (String)between + oldProp.trim();
    }

    public static class MailBuilder {
        private Logger _logger;
        private ExecutorService _executor;
        private boolean _async;
        private String _subject;
        private String _htmlBody;
        private String _textBody;
        private Collection<File> _attachments;
        private Collection<NamedStream> _streamAttachments;
        private List<String> _recipients;
        private String _sender;
        private List<String> _cc;
        private List<String> _bcc;
        private boolean _deliveryReceipt;
        private boolean _readReceipt;
        private String _host;
        private long _port = -1L;
        private String _securityProtocol;
        private String _user;
        private String _password;
        private boolean _singleEmail;
        private List<String> _errorReport;
        private boolean _inlineCSS = true;
        private boolean _embedBase64Resources = true;
        private Map<String, Pair<String, String>> _embeddedResources;

        MailBuilder(Logger logger, ExecutorService executor) {
            this._logger = logger;
            this._executor = executor;
        }

        public MailBuilder withAsync(boolean async) {
            this._async = async;
            return this;
        }

        public MailBuilder withSubject(String subject) {
            this._subject = subject;
            return this;
        }

        public MailBuilder withHTMLBody(String htmlBody) {
            this._htmlBody = htmlBody;
            return this;
        }

        public MailBuilder withHTMLBody(String htmlBody, Map<String, Pair<String, String>> embeddedResource) {
            this._htmlBody = htmlBody;
            this._embeddedResources = embeddedResource;
            return this;
        }

        public MailBuilder withTextBody(String textBody) {
            this._textBody = textBody;
            return this;
        }

        public MailBuilder withAttachments(Collection<File> attachments) {
            this._attachments = attachments;
            return this;
        }

        public MailBuilder withAttachmentsAsStream(Collection<NamedStream> attachments) {
            this._streamAttachments = attachments;
            return this;
        }

        public MailBuilder withRecipient(String recipient) {
            this._recipients = List.of(recipient);
            return this;
        }

        public MailBuilder withRecipients(List<String> recipients) {
            this._recipients = recipients;
            return this;
        }

        public MailBuilder withSender(String sender) {
            this._sender = sender;
            return this;
        }

        public MailBuilder withCc(List<String> cc) {
            this._cc = cc;
            return this;
        }

        public MailBuilder withBcc(List<String> bcc) {
            this._bcc = bcc;
            return this;
        }

        public MailBuilder withDeliveryReceipt(boolean deliveryReceipt) {
            this._deliveryReceipt = deliveryReceipt;
            return this;
        }

        public MailBuilder withReadReceipt(boolean readReceipt) {
            this._readReceipt = readReceipt;
            return this;
        }

        public MailBuilder withHost(String host) {
            this._host = host;
            return this;
        }

        public MailBuilder withPort(long port) {
            this._port = port;
            return this;
        }

        public MailBuilder withSecurityProtocol(String securityProtocol) {
            this._securityProtocol = securityProtocol;
            return this;
        }

        public MailBuilder withUser(String user) {
            this._user = user;
            return this;
        }

        public MailBuilder withPassword(String password) {
            this._password = password;
            return this;
        }

        public MailBuilder withSingleEmail(boolean singleEmail) {
            this._singleEmail = singleEmail;
            return this;
        }

        public MailBuilder withErrorReport(List<String> errorReport) {
            this._errorReport = errorReport;
            return this;
        }

        public MailBuilder withInlineCSS(boolean inlineCSS) {
            this._inlineCSS = inlineCSS;
            return this;
        }

        public MailBuilder withEmbeddedBase64Resources(boolean embedBase64Resources) {
            this._embedBase64Resources = embedBase64Resources;
            return this;
        }

        public void sendMail() throws MessagingException, IOException {
            Optional<Config> config = Optional.ofNullable(Config.getInstance());
            Collection<NamedStream> streamAttachments = this._streamAttachments;
            if (this._async && this._streamAttachments != null) {
                ArrayList<NamedStream> clonedStreamAttachments = new ArrayList<NamedStream>();
                for (NamedStream streamAttachment : this._streamAttachments) {
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                        SourceUtil.copy((InputStream)streamAttachment.inputStream(), (OutputStream)baos);
                        ByteArrayInputStream bin = new ByteArrayInputStream(baos.toByteArray());
                        clonedStreamAttachments.add(new NamedStream(bin, streamAttachment.name(), streamAttachment.mimeType()));
                    }
                }
                streamAttachments = clonedStreamAttachments;
            }
            MailSender mailSender = new MailSender(this._logger, this._subject, this._textBody, this._prepareHTMLBody(this._htmlBody), this._embeddedResources, this._attachments, streamAttachments, this._recipients, (String)StringUtils.defaultIfEmpty((CharSequence)this._sender, (CharSequence)config.map(c -> (String)c.getValue("smtp.mail.from")).orElse(null)), this._cc, this._bcc, this._deliveryReceipt, this._readReceipt, (String)StringUtils.defaultIfEmpty((CharSequence)this._host, (CharSequence)config.map(c -> (String)c.getValue("smtp.mail.host")).orElse(null)), this._port > 0L ? this._port : config.map(c -> (Long)c.getValue("smtp.mail.port")).orElse(0L), (String)StringUtils.defaultIfEmpty((CharSequence)this._securityProtocol, (CharSequence)config.map(c -> (String)c.getValue("smtp.mail.security.protocol")).orElse(null)), (String)StringUtils.defaultIfEmpty((CharSequence)this._user, (CharSequence)config.map(c -> (String)c.getValue("smtp.mail.user")).orElse(null)), (String)StringUtils.defaultIfEmpty((CharSequence)this._password, (CharSequence)config.map(c -> (String)c.getValue("smtp.mail.password")).orElse(null)), this._singleEmail, this._errorReport);
            if (!this._async) {
                mailSender.sendMail();
            } else {
                this._executor.execute(mailSender);
            }
        }

        private String _prepareHTMLBody(String htmlBody) {
            String result = htmlBody;
            if (result != null) {
                if (this._inlineCSS) {
                    result = SendMailHelper.inlineCSS(result);
                }
                if (this._embedBase64Resources) {
                    result = this._embedBase64Resources(result);
                }
            }
            return result;
        }

        private String _embedBase64Resources(String html) {
            Pattern pattern = Pattern.compile("\"data:(\\w+/\\w+);base64,(\\S*)\"");
            Matcher matcher = pattern.matcher(html);
            if (this._embeddedResources == null) {
                this._embeddedResources = new HashMap<String, Pair<String, String>>();
            }
            return matcher.replaceAll(match -> {
                String mimeType = match.group(1);
                String base64Resource = this._fold(match.group(2));
                String hashCode = Integer.toString(base64Resource.hashCode());
                this._embeddedResources.putIfAbsent(hashCode, (Pair<String, String>)Pair.of((Object)mimeType, (Object)base64Resource));
                return "\"cid:" + hashCode + "\"";
            });
        }

        private String _fold(String base64) {
            StringBuilder sb = new StringBuilder(base64.length());
            int i = 0;
            while (i < base64.length()) {
                sb.append(base64.charAt(i++));
                if (i % 76 != 0) continue;
                sb.append('\r').append('\n');
            }
            return sb.toString();
        }
    }

    private static class CssRule
    implements Comparable<CssRule> {
        private String _selector;
        private String _properties;
        private CssSpecificity _specificity;

        public CssRule(String selector, String properties, int positionIdx) {
            this._selector = selector;
            this._properties = properties;
            this._specificity = new CssSpecificity(this._selector, positionIdx);
        }

        public String getSelector() {
            return this._selector;
        }

        public String getProperties() {
            return this._properties;
        }

        @Override
        public int compareTo(CssRule r) {
            return this._specificity.compareTo(r._specificity);
        }
    }

    private static class MailSenderThreadFactory
    implements ThreadFactory {
        private ThreadFactory _defaultThreadFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this._defaultThreadFactory.newThread(r);
            thread.setName("mail-sender-thread");
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class MailSender
    implements Runnable {
        private String _subject;
        private String _textBody;
        private String _htmlBody;
        private Map<String, Pair<String, String>> _embeddedAttachments;
        private Collection<File> _attachments;
        private Collection<NamedStream> _streamAttachments;
        private List<String> _recipients;
        private String _sender;
        private List<String> _cc;
        private List<String> _bcc;
        private boolean _deliveryReceipt;
        private boolean _readReceipt;
        private String _host;
        private long _port;
        private String _securityProtocol;
        private String _user;
        private String _password;
        private boolean _singleEmail;
        private List<String> _errorReport;
        private Logger _logger;

        public MailSender(Logger logger, String subject, String textBody, String htmlBody, Map<String, Pair<String, String>> embeddedResources, Collection<File> attachments, Collection<NamedStream> streamAttachments, List<String> recipients, String sender, List<String> cc, List<String> bcc, boolean deliveryReceipt, boolean readReceipt, String host, long port, String securityProtocol, String user, String password, boolean singleEmail, List<String> errorReport) {
            this._logger = logger;
            this._subject = subject;
            this._textBody = textBody;
            this._htmlBody = htmlBody;
            this._embeddedAttachments = embeddedResources;
            this._attachments = attachments;
            this._streamAttachments = streamAttachments;
            this._recipients = recipients;
            this._sender = sender;
            this._cc = cc;
            this._bcc = bcc;
            this._deliveryReceipt = deliveryReceipt;
            this._readReceipt = readReceipt;
            this._host = host;
            this._port = port;
            this._securityProtocol = securityProtocol;
            this._user = user;
            this._password = password;
            this._singleEmail = singleEmail;
            this._errorReport = errorReport;
        }

        @Override
        public void run() {
            try {
                this.sendMail();
            }
            catch (Exception e) {
                this._logger.error("Unable to send mail with subject: {}", (Object)this._subject, (Object)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMail() throws MessagingException, IOException {
            ArrayList<InputStreamDataSource> dataSources = new ArrayList<InputStreamDataSource>();
            try {
                Properties props = new Properties();
                props.put("mail.smtp.host", this._host);
                props.put("mail.smtp.port", (Object)this._port);
                if (this._securityProtocol.equals("starttls")) {
                    props.put("mail.smtp.starttls.enable", "true");
                } else if (this._securityProtocol.equals("tlsssl")) {
                    props.put("mail.smtp.ssl.enable", "true");
                }
                Session session = Session.getInstance((Properties)props, null);
                MimeMessage message = new MimeMessage(session);
                if (this._sender != null) {
                    message.setFrom((Address)new InternetAddress(this._sender));
                }
                message.setSentDate(new Date());
                message.setSubject(this._subject, "UTF-8");
                if (this._attachments == null && this._streamAttachments == null) {
                    this._setBodyPart((MimePart)message);
                } else {
                    MimeBodyPart fileBodyPart;
                    MimeMultipart multipart = new MimeMultipart("mixed");
                    MimeBodyPart bodyPart = new MimeBodyPart();
                    this._setBodyPart((MimePart)bodyPart);
                    multipart.addBodyPart((BodyPart)bodyPart);
                    if (this._attachments != null) {
                        for (File file : this._attachments) {
                            fileBodyPart = new MimeBodyPart();
                            fileBodyPart.attachFile(file);
                            multipart.addBodyPart((BodyPart)fileBodyPart);
                        }
                    }
                    if (this._streamAttachments != null) {
                        for (NamedStream namedStream : this._streamAttachments) {
                            fileBodyPart = new MimeBodyPart();
                            InputStreamDataSource fds = new InputStreamDataSource(namedStream);
                            dataSources.add(fds);
                            fileBodyPart.setDataHandler(new DataHandler((DataSource)fds));
                            fileBodyPart.setFileName(namedStream.name());
                            fileBodyPart.setDisposition("attachment");
                            multipart.addBodyPart((BodyPart)fileBodyPart);
                        }
                    }
                    message.setContent((Multipart)multipart);
                }
                if (this._cc != null) {
                    message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)StringUtils.join(this._cc, (char)','), (boolean)false));
                }
                if (this._bcc != null) {
                    message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)StringUtils.join(this._bcc, (char)','), (boolean)false));
                }
                if (this._deliveryReceipt) {
                    message.setHeader("Return-Receipt-To", this._sender);
                }
                if (this._readReceipt) {
                    message.setHeader("Disposition-Notification-To", this._sender);
                }
                try (Transport tr = session.getTransport("smtp");){
                    tr.connect(this._host, (int)this._port, StringUtils.trimToNull((String)this._user), StringUtils.trimToNull((String)this._password));
                    this._sendMail(message, tr);
                }
            }
            finally {
                for (InputStreamDataSource dataSource : dataSources) {
                    dataSource.dispose();
                }
            }
        }

        private void _setBodyPart(MimePart part) throws MessagingException {
            if (this._textBody != null && this._htmlBody != null) {
                MimeMultipart bodyMultipart = new MimeMultipart("alternative");
                MimeBodyPart textPart = new MimeBodyPart();
                bodyMultipart.addBodyPart((BodyPart)textPart);
                this._setTextBody((MimePart)textPart);
                MimeBodyPart htmlPart = new MimeBodyPart();
                bodyMultipart.addBodyPart((BodyPart)htmlPart);
                this._setHTMLBody((MimePart)htmlPart);
                part.setContent((Multipart)bodyMultipart);
            } else if (this._textBody != null) {
                this._setTextBody(part);
            } else if (this._htmlBody != null) {
                this._setHTMLBody(part);
            }
        }

        private void _setTextBody(MimePart part) throws MessagingException {
            part.setText(this._textBody, "UTF-8");
        }

        private void _setHTMLBody(MimePart part) throws MessagingException {
            if (this._embeddedAttachments != null && this._embeddedAttachments.size() > 0) {
                MimeMultipart relatedMultipart = new MimeMultipart("related");
                part.setContent((Multipart)relatedMultipart);
                MimeBodyPart htmlPart = new MimeBodyPart();
                relatedMultipart.addBodyPart((BodyPart)htmlPart);
                htmlPart.setText(this._htmlBody, "UTF-8", "html");
                for (Map.Entry<String, Pair<String, String>> entry : this._embeddedAttachments.entrySet()) {
                    PreencodedMimeBodyPart entryPart = new PreencodedMimeBodyPart("base64");
                    entryPart.setContentID("<" + entry.getKey() + ">");
                    entryPart.setDisposition("inline");
                    entryPart.setFileName(entry.getKey());
                    entryPart.setContent(entry.getValue().getRight(), (String)entry.getValue().getLeft());
                    relatedMultipart.addBodyPart((BodyPart)entryPart);
                }
            } else {
                part.setText(this._htmlBody, "UTF-8", "html");
            }
        }

        private void _sendMail(MimeMessage message, Transport tr) throws MessagingException {
            if (this._recipients != null && this._recipients.size() > 0 && this._sender != null) {
                if (this._singleEmail) {
                    message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)StringUtils.join(this._recipients, (char)','), (boolean)false));
                    message.saveChanges();
                    tr.sendMessage((Message)message, message.getAllRecipients());
                } else {
                    for (String recipient : this._recipients) {
                        try {
                            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient, (boolean)false));
                            message.saveChanges();
                            tr.sendMessage((Message)message, message.getAllRecipients());
                        }
                        catch (Exception e) {
                            if (this._errorReport != null) {
                                this._errorReport.add(recipient);
                            }
                            this._logger.error("Can't send mail with subject \"{}\" to the address {}", new Object[]{this._subject, recipient, e});
                        }
                    }
                }
            }
        }
    }

    public record NamedStream(InputStream inputStream, String name, String mimeType) {
    }

    private static class CssSpecificity
    implements Comparable<CssSpecificity> {
        private static final Pattern __CSS_SPECIFICITY_ATTR_PATTERN = Pattern.compile("(\\[[^\\]]+\\])");
        private static final Pattern __CSS_SPECIFICITY_ID_PATTERN = Pattern.compile("(#[^\\s\\+>~\\.\\[:]+)");
        private static final Pattern __CSS_SPECIFICITY_CLASS_PATTERN = Pattern.compile("(\\.[^\\s\\+>~\\.\\[:]+)");
        private static final Pattern __CSS_SPECIFICITY_PSEUDO_ELEMENT_PATTERN = Pattern.compile("(::[^\\s\\+>~\\.\\[:]+|:first-line|:first-letter|:before|:after)", 2);
        private static final Pattern __CSS_SPECIFICITY_PSEUDO_CLASS_WITH_BRACKETS_PATTERN = Pattern.compile("(:[\\w-]+\\([^\\)]*\\))", 2);
        private static final Pattern __CSS_SPECIFICITY_PSEUDO_CLASS_PATTERN = Pattern.compile("(:[^\\s\\+>~\\.\\[:]+)");
        private static final Pattern __CSS_SPECIFICITY_ELEMENT_PATTERN = Pattern.compile("([^\\s\\+>~\\.\\[:]+)");
        private static final Pattern __CSS_SPECIFICITY_PSEUDO_CLASS_NOT_PATTERN = Pattern.compile(":not\\(([^\\)]*)\\)");
        private static final Pattern __CSS_SPECIFICITY_UNIVERSAL_AND_SEPARATOR_PATTERN = Pattern.compile("[\\*\\s\\+>~]");
        private int[] _weights;

        public CssSpecificity(String selector, int positionIdx) {
            this._weights = new int[]{0, 0, 0, 0, positionIdx};
            String input = selector;
            input = __CSS_SPECIFICITY_PSEUDO_CLASS_NOT_PATTERN.matcher(input).replaceAll(" $1 ");
            input = this._countReplaceAll(__CSS_SPECIFICITY_ATTR_PATTERN, input, 2);
            input = this._countReplaceAll(__CSS_SPECIFICITY_ID_PATTERN, input, 1);
            input = this._countReplaceAll(__CSS_SPECIFICITY_CLASS_PATTERN, input, 2);
            input = this._countReplaceAll(__CSS_SPECIFICITY_PSEUDO_ELEMENT_PATTERN, input, 3);
            input = this._countReplaceAll(__CSS_SPECIFICITY_PSEUDO_CLASS_WITH_BRACKETS_PATTERN, input, 2);
            input = this._countReplaceAll(__CSS_SPECIFICITY_PSEUDO_CLASS_PATTERN, input, 2);
            input = __CSS_SPECIFICITY_UNIVERSAL_AND_SEPARATOR_PATTERN.matcher(input).replaceAll(" ");
            this._countReplaceAll(__CSS_SPECIFICITY_ELEMENT_PATTERN, input, 3);
        }

        private String _countReplaceAll(Pattern pattern, String selector, int sIndex) {
            Matcher m = pattern.matcher(selector);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                int n = sIndex;
                this._weights[n] = this._weights[n] + 1;
                m.appendReplacement(sb, " ");
            }
            m.appendTail(sb);
            return sb.toString();
        }

        @Override
        public int compareTo(CssSpecificity o) {
            for (int i = 0; i < this._weights.length; ++i) {
                if (this._weights[i] == o._weights[i]) continue;
                return this._weights[i] - o._weights[i];
            }
            return 0;
        }
    }
}

