/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.path;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.util.LambdaUtils;
import org.ametys.core.util.path.PathTimeStampValidity;
import org.ametys.core.util.path.PathUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.MoveableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.FileSource;

public class PathSource
implements ModifiableTraversableSource,
MoveableSource {
    protected Path _path;
    protected String _scheme;
    protected String _uri;
    protected String _externalUri;

    protected PathSource() {
    }

    public PathSource(String uri) throws SourceException, MalformedURLException {
        int pos = SourceUtil.indexOfSchemeColon((String)uri);
        if (pos == -1) {
            throw new MalformedURLException("Invalid URI : " + uri);
        }
        String scheme = uri.substring(0, pos);
        String fileName = uri.substring(pos + 1);
        fileName = SourceUtil.decodePath((String)fileName);
        this.init(scheme, Path.of(fileName, new String[0]));
    }

    public PathSource(String scheme, Path path) throws SourceException {
        this.init(scheme, path);
    }

    public PathSource(String scheme, String uri, Path path) {
        this._scheme = scheme;
        this._uri = uri.replace('\\', '/');
        this._path = path;
    }

    private void init(String scheme, Path path) throws SourceException {
        Object uri;
        this._scheme = scheme;
        try {
            uri = path.toUri().toURL().toExternalForm();
        }
        catch (MalformedURLException mue) {
            throw new SourceException("Failed to get URL for file " + String.valueOf(path), (Throwable)mue);
        }
        if (!((String)uri).startsWith(scheme)) {
            uri = scheme + ":" + ((String)uri).substring(((String)uri).indexOf(58) + 1);
        }
        this._uri = uri;
        this._path = path;
    }

    public Path getFile() {
        return this._path;
    }

    public long getContentLength() {
        try {
            return Files.size(this._path);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public InputStream getInputStream() throws IOException, SourceNotFoundException {
        try {
            return Files.newInputStream(this._path, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            throw new SourceNotFoundException(this._uri + " doesn't exist.", (Throwable)e);
        }
        catch (IOException e) {
            throw new SourceException("An error occurred while opening " + this._uri + ".", (Throwable)e);
        }
    }

    public long getLastModified() {
        try {
            return Files.getLastModifiedTime(this._path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public String getMimeType() {
        return URLConnection.getFileNameMap().getContentTypeFor(this._path.getFileName().toString());
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getURI() {
        try {
            if (this._externalUri == null) {
                this._externalUri = this._uri + "?path=" + new String(Base64.getEncoder().withoutPadding().encode(this._path.toUri().toURL().toExternalForm().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            }
            return this._externalUri;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public SourceValidity getValidity() {
        if (Files.exists(this._path, new LinkOption[0])) {
            return new PathTimeStampValidity(this._path);
        }
        return null;
    }

    public void refresh() {
    }

    public boolean exists() {
        return Files.exists(this.getFile(), new LinkOption[0]);
    }

    public Source getChild(String name) throws SourceException {
        if (!Files.isDirectory(this._path, new LinkOption[0])) {
            throw new SourceException(this.getURI() + " is not a directory");
        }
        Path subPath = this._path.resolve(name);
        return new PathSource(this.getScheme(), this._uri + "/" + subPath.getFileName().toString(), subPath);
    }

    public Collection getChildren() throws SourceException {
        Collection collection;
        block10: {
            if (!Files.isDirectory(this._path, new LinkOption[0])) {
                throw new SourceException(this.getURI() + " is not a directory");
            }
            Stream<Path> files = Files.list(this._path);
            try {
                collection = files.map(LambdaUtils.wrap(path -> new PathSource(this.getScheme(), this._uri + "/" + path.getFileName().toString(), (Path)path))).collect(Collectors.toList());
                if (files == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LambdaUtils.LambdaException e) {
                    throw (SourceException)e.getCause();
                }
                catch (IOException e) {
                    throw new SourceException("Cannot list files under " + String.valueOf(this._path), (Throwable)e);
                }
            }
            files.close();
        }
        return collection;
    }

    public String getName() {
        return this._path.getFileName().toString();
    }

    public Source getParent() throws SourceException {
        String specificPath = StringUtils.substringAfter((String)this._uri, (String)"://");
        int lastIndexOf = specificPath.lastIndexOf(47);
        if (lastIndexOf == -1) {
            return null;
        }
        String parentPath = specificPath.substring(0, lastIndexOf);
        if (parentPath.matches("^/*$")) {
            return null;
        }
        return new PathSource(this.getScheme(), parentPath, this._path.getParent());
    }

    public boolean isCollection() {
        return Files.isDirectory(this._path, new LinkOption[0]);
    }

    public OutputStream getOutputStream() throws IOException {
        Path tmpFile = this.getFile().getParent().resolve(String.valueOf(this.getFile().getFileName()) + ".tmp");
        if (Files.exists(this.getFile(), new LinkOption[0]) && !Files.isWritable(this.getFile())) {
            throw new IOException("Cannot write to file " + this.getFile().toString());
        }
        try {
            Files.createFile(tmpFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ConcurrentModificationException("File " + this.getFile().toString() + " is already being written by another thread", e);
        }
        return new PathSourceOutputStream(tmpFile, this);
    }

    public boolean canCancel(OutputStream stream) {
        PathSourceOutputStream fsos;
        if (stream instanceof PathSourceOutputStream && (fsos = (PathSourceOutputStream)stream).getSource() == this) {
            return fsos.canCancel();
        }
        throw new IllegalArgumentException("The stream is not associated to this source");
    }

    public void cancel(OutputStream stream) throws SourceException {
        PathSourceOutputStream fsos;
        if (stream instanceof PathSourceOutputStream && (fsos = (PathSourceOutputStream)stream).getSource() == this) {
            try {
                fsos.cancel();
            }
            catch (Exception e) {
                throw new SourceException("Exception during cancel.", (Throwable)e);
            }
            return;
        }
        throw new IllegalArgumentException("The stream is not associated to this source");
    }

    public void delete() throws SourceException {
        if (!Files.exists(this._path, new LinkOption[0])) {
            throw new SourceNotFoundException("Cannot delete non-existing file " + this._path.toString());
        }
        try {
            Files.deleteIfExists(this._path);
        }
        catch (IOException e) {
            throw new SourceException("Could not delete " + this._path.toString() + " (unknown reason)", (Throwable)e);
        }
    }

    public void makeCollection() throws SourceException {
        try {
            Files.createDirectories(this._path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SourceException("Could not create collection " + this.getFile().toString(), (Throwable)e);
        }
    }

    public void copyTo(Source destination) throws SourceException {
        try (InputStream is = this.getInputStream();
             OutputStream os = ((ModifiableSource)destination).getOutputStream();){
            SourceUtil.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException ioe) {
            throw new SourceException("Couldn't copy " + this.getURI() + " to " + destination.getURI(), (Throwable)ioe);
        }
    }

    public void moveTo(Source destination) throws SourceException {
        if (destination instanceof FileSource) {
            Path dest = ((PathSource)destination).getFile();
            Path parent = dest.getParent();
            if (parent != null) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new SourceException("Couldn't move " + this.getURI() + " to " + destination.getURI(), (Throwable)e);
                }
            }
            try {
                Files.move(this._path, dest, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new SourceException("Couldn't move " + this.getURI() + " to " + destination.getURI(), (Throwable)e);
            }
        }
        SourceUtil.move((Source)this, (Source)destination);
    }

    private static class PathSourceOutputStream
    extends OutputStream {
        private OutputStream _os;
        private boolean _isClosed;
        private PathSource _source;
        private Path _tmpFile;

        public PathSourceOutputStream(Path tmpFile, PathSource source) throws IOException {
            this._tmpFile = tmpFile;
            this._os = Files.newOutputStream(tmpFile, new OpenOption[0]);
            this._source = source;
        }

        @Override
        public void write(int b) throws IOException {
            this._os.write(b);
        }

        @Override
        public void flush() throws IOException {
            this._os.flush();
        }

        @Override
        public void close() throws IOException {
            if (!this._isClosed) {
                this._os.close();
                try {
                    Files.deleteIfExists(this._source.getFile());
                    Files.move(this._tmpFile, this._source.getFile(), new CopyOption[0]);
                }
                finally {
                    Files.deleteIfExists(this._tmpFile);
                    this._isClosed = true;
                }
            }
        }

        public boolean canCancel() {
            return !this._isClosed;
        }

        public void cancel() throws Exception {
            if (this._isClosed) {
                throw new IllegalStateException("Cannot cancel : outputstrem is already closed");
            }
            this._isClosed = true;
            this._os.close();
            Files.deleteIfExists(this._tmpFile);
        }

        public void finalize() throws Throwable {
            super.finalize();
            if (!this._isClosed) {
                PathUtils.deleteQuietly(this._tmpFile);
            }
        }

        public PathSource getSource() {
            return this._source;
        }
    }
}

