/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.path;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.ametys.core.util.JarFSManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceValidity;

public class PathTimeStampValidity
implements SourceValidity {
    protected long _timeStamp;
    private transient Path _file;
    private String _absolutePath;

    public PathTimeStampValidity(String filename) {
        this(Path.of(filename, new String[0]));
    }

    public PathTimeStampValidity(Path file) {
        this(file, PathTimeStampValidity._getTimeStamp(file));
    }

    public PathTimeStampValidity(Path file, long timeStamp) {
        this._file = file;
        try {
            this._absolutePath = new URI(file.toUri().getRawSchemeSpecificPart()).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Cannot convert " + file.toString() + " to URI", e);
        }
        this._timeStamp = timeStamp;
    }

    protected PathTimeStampValidity() {
    }

    protected static long _getTimeStamp(Path file) {
        try {
            return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public int isValid() {
        return PathTimeStampValidity._getTimeStamp(this.getFile()) == this._timeStamp ? 1 : -1;
    }

    public int isValid(SourceValidity newValidity) {
        if (newValidity instanceof PathTimeStampValidity) {
            long timeStamp = ((PathTimeStampValidity)newValidity).getTimeStamp();
            return this._timeStamp == timeStamp ? 1 : -1;
        }
        return -1;
    }

    public Path getFile() {
        if (this._file == null) {
            this._file = PathTimeStampValidity._getFile(this._absolutePath);
        }
        return this._file;
    }

    protected static Path _getFile(String absolutePath) {
        String[] path = StringUtils.split((String)absolutePath, (String)"!");
        if (path.length == 2) {
            try {
                return JarFSManager.getInstance().getFileSystemByFile(new File(path[0])).getPath(path[1], new String[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot unserialize the path " + absolutePath, e);
            }
        }
        return new File(path[0]).toPath();
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public String toString() {
        return "FileTimeStampValidity: " + this.getFile().toString() + ": " + this._timeStamp;
    }
}

