/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.authentication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.directory.UserDirectoryFactory;
import org.ametys.core.user.directory.UserDirectoryModel;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.JSONUtils;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerDescriptor;
import org.ametys.runtime.model.type.ModelItemType;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class CheckUserDirectoryAction
extends ServiceableAction {
    private JSONUtils _jsonUtils;
    private UserDirectoryFactory _userDirectoryFactory;
    private UserPopulationDAO _userPopulationDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
        this._userDirectoryFactory = (UserDirectoryFactory)smanager.lookup(UserDirectoryFactory.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
        super.service(smanager);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String fieldCheckersInfoJSON = request.getParameter("fieldCheckersInfo");
        Map<String, Object> fieldCheckersInfo = this._jsonUtils.convertJsonToMap(fieldCheckersInfoJSON);
        Map<String, Object> valuesByParameterChecker = this._getValuesByParamCheckerId(fieldCheckersInfo);
        for (String fieldCheckerId : valuesByParameterChecker.keySet()) {
            ItemChecker fieldChecker = (ItemChecker)((Map)valuesByParameterChecker.get(fieldCheckerId)).get("checker");
            List values = (List)((Map)valuesByParameterChecker.get(fieldCheckerId)).get("values");
            try {
                fieldChecker.check(values);
            }
            catch (Throwable t) {
                this.getLogger().error("The test '" + fieldCheckerId + "' failed : \n" + t.getMessage(), t);
                String msg = t.getMessage() != null ? t.getMessage() : "Unknown error";
                result.put(fieldCheckerId, msg);
            }
        }
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return result;
    }

    private Map<String, Object> _getValuesByParamCheckerId(Map<String, Object> paramCheckersInfo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String populationId = (String)paramCheckersInfo.get("_user_population_id");
        paramCheckersInfo.remove("_user_population_id");
        UserPopulation userPopulation = null;
        for (String paramCheckerId : paramCheckersInfo.keySet()) {
            HashMap<String, Object> valuesByParamCheckerId = new HashMap<String, Object>();
            ItemCheckerDescriptor parameterCheckerDescriptor = null;
            UserDirectoryModel udModel = null;
            block1: for (String userDirectoryModelId : this._userDirectoryFactory.getExtensionsIds()) {
                if (parameterCheckerDescriptor != null) break;
                udModel = this._userDirectoryFactory.getExtension(userDirectoryModelId);
                for (String localCheckerId : udModel.getParameterCheckers().keySet()) {
                    if (!localCheckerId.equals(paramCheckerId)) continue;
                    parameterCheckerDescriptor = udModel.getParameterCheckers().get(localCheckerId);
                    continue block1;
                }
            }
            if (udModel == null || parameterCheckerDescriptor == null) {
                throw new IllegalArgumentException("The parameter checker '" + paramCheckerId + "' was not found.");
            }
            ItemChecker parameterChecker = parameterCheckerDescriptor.getParameterChecker();
            valuesByParamCheckerId.put("checker", parameterChecker);
            List paramNames = (List)((Map)paramCheckersInfo.get(paramCheckerId)).get("testParamsNames");
            List paramRawValues = (List)((Map)paramCheckersInfo.get(paramCheckerId)).get("rawTestValues");
            ArrayList<String> values = new ArrayList<String>();
            String udId = (String)paramRawValues.get(paramRawValues.size() - 1);
            for (int i = 0; i < paramNames.size() - 1; ++i) {
                String paramName = StringUtils.substringAfter((String)((String)paramNames.get(i)), (String)"$");
                ModelItemType type = udModel.getParameters().get(paramName).getType();
                String untypedValue = type.toString(paramRawValues.get(i));
                if (untypedValue == null && "password".equals(type.getId())) {
                    if (userPopulation == null) {
                        userPopulation = this._userPopulationDAO.getUserPopulation(populationId);
                    }
                    UserDirectory ud = userPopulation.getUserDirectory(udId);
                    values.add((String)ud.getParameterValues().get(paramName));
                    continue;
                }
                values.add(untypedValue);
            }
            valuesByParamCheckerId.put("values", values);
            result.put(paramCheckerId, valuesByParamCheckerId);
        }
        return result;
    }
}

