/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.authentication;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ametys.core.authentication.BlockingCredentialProvider;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.authentication.CredentialProviderFactory;
import org.ametys.core.authentication.CredentialProviderModel;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.authentication.MultifactorAuthenticationManager;
import org.ametys.plugins.core.impl.authentication.FormCredentialProvider;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.servlet.RuntimeServlet;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LoginScreenGenerator
extends ServiceableGenerator {
    protected CredentialProviderFactory _credentialProviderFactory;
    protected UserPopulationDAO _userPopulationDAO;
    protected JSONUtils _jsonUtils;
    protected I18nUtils _i18nUtils;
    protected UserManager _userManager;
    protected MultifactorAuthenticationManager _multifactorAuthenticationManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._credentialProviderFactory = (CredentialProviderFactory)smanager.lookup(CredentialProviderFactory.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
        this._i18nUtils = (I18nUtils)((Object)smanager.lookup(I18nUtils.ROLE));
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._multifactorAuthenticationManager = (MultifactorAuthenticationManager)smanager.lookup(MultifactorAuthenticationManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"LoginScreen");
        boolean isAmetysPublic = Config.getInstance() != null ? (Boolean)Config.getInstance().getValue("runtime.ametys.public") : false;
        boolean invalidPopulationIds = "true".equals(request.getParameter("invalidPopulationIds"));
        boolean shouldDisplayUserPopulationsList = "true".equals(request.getParameter("shouldDisplayUserPopulationsList"));
        List usersPopulations = null;
        String usersPopulationsIdsAsString = request.getParameter("usersPopulations");
        if (usersPopulationsIdsAsString != null) {
            usersPopulations = Arrays.stream(usersPopulationsIdsAsString.split(",")).map(this._userPopulationDAO::getUserPopulation).filter(Objects::nonNull).collect(Collectors.toList());
        }
        String chosenPopulationId = request.getParameter("chosenPopulationId");
        if (shouldDisplayUserPopulationsList) {
            this._generatePopulations(usersPopulations, isAmetysPublic, invalidPopulationIds, chosenPopulationId);
        }
        boolean availableCredentialProviders = "true".equals(request.getParameter("availableCredentialProviders"));
        List<CredentialProvider> credentialProviders = null;
        if (availableCredentialProviders && usersPopulations != null && !usersPopulations.isEmpty()) {
            credentialProviders = StringUtils.isNotBlank((CharSequence)chosenPopulationId) ? usersPopulations.stream().filter(userPop -> chosenPopulationId.equals(userPop.getId())).findAny().get().getCredentialProviders() : ((UserPopulation)usersPopulations.get(0)).getCredentialProviders();
        }
        int credentialProviderIndex = Integer.parseInt(request.getParameter("credentialProviderIndex"));
        this._generateCredentialProviders(credentialProviders, credentialProviderIndex);
        this._generateLoginForm(request, credentialProviders, credentialProviderIndex, invalidPopulationIds, chosenPopulationId != null || usersPopulations == null ? chosenPopulationId : ((UserPopulation)usersPopulations.get(0)).getId());
        String contextsAsString = request.getParameter("contexts");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"contexts", (String)contextsAsString);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"LoginScreen");
        this.contentHandler.endDocument();
    }

    private void _generatePopulations(List<UserPopulation> usersPopulations, boolean isAmetysPublic, boolean triedAnInvalidPopulationId, String chosenPopulationId) throws SAXException {
        if (usersPopulations != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("invalid", triedAnInvalidPopulationId ? "true" : "false");
            attrs.addCDATAAttribute("public", isAmetysPublic ? "true" : "false");
            attrs.addCDATAAttribute("size", Integer.toString(usersPopulations.size()));
            if (chosenPopulationId != null) {
                attrs.addCDATAAttribute("currentValue", chosenPopulationId);
            }
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"UserPopulations", (Attributes)attrs);
            if (!isAmetysPublic) {
                for (UserPopulation up : usersPopulations) {
                    AttributesImpl attrs2 = new AttributesImpl();
                    attrs2.addCDATAAttribute("id", up.getId());
                    XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"UserPopulation", (Attributes)attrs2);
                    up.getLabel().toSAX(this.contentHandler, "label");
                    XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"UserPopulation");
                }
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"UserPopulations");
        }
    }

    private void _generateCredentialProviders(List<CredentialProvider> credentialProviders, int currentCredentialProvider) throws SAXException {
        if (credentialProviders == null) {
            return;
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"CredentialProviders");
        for (int index = 0; index < credentialProviders.size(); ++index) {
            CredentialProvider cp = credentialProviders.get(index);
            if (!(cp instanceof BlockingCredentialProvider)) continue;
            BlockingCredentialProvider blockingCP = (BlockingCredentialProvider)cp;
            CredentialProviderModel cpModel = this._credentialProviderFactory.getExtension(cp.getCredentialProviderModelId());
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("index", String.valueOf(index));
            attrs.addCDATAAttribute("selected", index == currentCredentialProvider ? "true" : "false");
            attrs.addCDATAAttribute("isForm", cp instanceof FormCredentialProvider ? "true" : "false");
            attrs.addCDATAAttribute("isNewWindowRequired", blockingCP.requiresNewWindow() ? "true" : "false");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"CredentialProvider", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"label", (String)this._i18nUtils.translate(cpModel.getConnectionLabel()));
            if (StringUtils.isNotBlank((CharSequence)cp.getLabel())) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"additionalLabel", (String)cp.getLabel());
            }
            if (StringUtils.isNotEmpty((CharSequence)cpModel.getIconGlyph())) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"iconGlyph", (String)cpModel.getIconGlyph());
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"iconDecorator", (String)cpModel.getIconDecorator());
            } else if (StringUtils.isNotEmpty((CharSequence)cpModel.getIconMedium())) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"iconMedium", (String)cpModel.getIconMedium());
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"color", (String)cpModel.getColor());
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"CredentialProvider");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"CredentialProviders");
    }

    /*
     * Unable to fully structure code
     */
    private void _generateLoginForm(Request request, List<CredentialProvider> credentialProviders, int currentCredentialProvider, boolean invalidPopulationIds, String chosenPopulationId) throws SAXException {
        if (credentialProviders == null) {
            return;
        }
        formBasedCP = null;
        if (currentCredentialProvider != -1 && credentialProviders.get(currentCredentialProvider) instanceof FormCredentialProvider) {
            formBasedCP = (FormCredentialProvider)credentialProviders.get(currentCredentialProvider);
        } else {
            foundAnyFormCredentialProvider = credentialProviders.stream().filter((Predicate<CredentialProvider>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$_generateLoginForm$1(org.ametys.core.authentication.CredentialProvider ), (Lorg/ametys/core/authentication/CredentialProvider;)Z)()).findAny();
            if (foundAnyFormCredentialProvider.isPresent()) {
                formBasedCP = (FormCredentialProvider)foundAnyFormCredentialProvider.get();
            } else {
                return;
            }
        }
        useCaptcha = (Boolean)formBasedCP.getParameterValues().get("runtime.authentication.form.captcha");
        if (!formBasedCP.displayResetLink() || RuntimeServlet.getRunMode() != RuntimeServlet.RunMode.NORMAL || !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{chosenPopulationId})) ** GOTO lbl-1000
        if (this._userPopulationDAO.getUserPopulation(chosenPopulationId).getUserDirectories().stream().anyMatch((Predicate<UserDirectory>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/ametys/core/user/directory/UserDirectory;)Z)(ModifiableUserDirectory.class))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        displayResetLink = v0;
        autoComplete = true;
        rememberMe = (Boolean)formBasedCP.getParameterValues().get("runtime.authentication.form.cookies");
        allowLoginByEmail = (Boolean)formBasedCP.getParameterValues().get("runtime.authentication.form.login-by-email");
        useMultifactorAuthentication = formBasedCP.useMultifactorAuthentication();
        captcha = false;
        if (useCaptcha && StringUtils.isNotBlank((CharSequence)(login = request.getParameter("login"))) && StringUtils.isNotBlank((CharSequence)chosenPopulationId)) {
            nbConnect = formBasedCP.requestNbConnectBDD(login, chosenPopulationId);
            captcha = nbConnect >= FormCredentialProvider.NB_CONNECTION_ATTEMPTS;
        }
        showErrors = invalidPopulationIds == false;
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"LoginForm");
        if (StringUtils.isNotBlank((CharSequence)formBasedCP.getLabel())) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"additionalLabel", (String)formBasedCP.getLabel());
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"autocomplete", (String)String.valueOf(autoComplete));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"rememberMe", (String)String.valueOf(rememberMe));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"useCaptcha", (String)String.valueOf(captcha));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"allowLoginByEmail", (String)String.valueOf(allowLoginByEmail));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"displayForgottenLink", (String)String.valueOf(displayResetLink));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"useMultifactorAuthentication", (String)String.valueOf(useMultifactorAuthentication));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"showErrors", (String)String.valueOf(showErrors));
        this._generateMultifactorAuthentication(request);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"LoginForm");
    }

    private void _generateMultifactorAuthentication(Request request) throws SAXException {
        String currentUserAsString = request.getParameter("userIdentity");
        UserIdentity currentUser = UserIdentity.stringToUserIdentity(currentUserAsString);
        if (currentUser == null) {
            return;
        }
        Optional<String> email = this._getUserEmail(currentUser);
        if (email.isEmpty()) {
            return;
        }
        String mfaMode = request.getParameter("MFAMode");
        boolean invalidMFACode = "true".equals(request.getParameter("invalidMFACode"));
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("invalid", Boolean.toString(invalidMFACode));
        attrs.addCDATAAttribute("email", email.get());
        attrs.addCDATAAttribute("duration", Integer.toString(this._multifactorAuthenticationManager.getEmailCodeDuration()));
        attrs.addCDATAAttribute("mode", mfaMode);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"MultifactorAuthentication", (Attributes)attrs);
    }

    private Optional<String> _getUserEmail(UserIdentity currentUserIdentity) {
        User currentUser = this._userManager.getUser(currentUserIdentity);
        String email = currentUser.getEmail();
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            int at = email.indexOf("@");
            String escapedEmail = at > 2 ? email.substring(0, 2) + email.substring(2, at).replaceAll(".", "*") + email.substring(at) : email;
            return Optional.of(escapedEmail);
        }
        return Optional.empty();
    }

    private static /* synthetic */ boolean lambda$_generateLoginForm$1(CredentialProvider cp) {
        return cp instanceof FormCredentialProvider;
    }
}

