/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.authentication;

import java.io.File;
import org.ametys.core.util.CryptoHelper;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class MultifactorAuthenticationCryptoHelper
extends CryptoHelper
implements Initializable {
    private static final String __MFA_KEY_FILE_PREFIX = "mfa/mfa_";

    @Override
    protected String _configureFilename(Configuration configuration) throws ConfigurationException {
        String userPopulationId = configuration.getChild("userPopulationId").getValue();
        return __MFA_KEY_FILE_PREFIX + userPopulationId;
    }

    public void initialize() throws Exception {
        File mfaKeyFile = new File(AmetysHomeHelper.getAmetysHomeConfig(), this._getFilename());
        if (!mfaKeyFile.exists()) {
            if (!mfaKeyFile.getParentFile().exists()) {
                mfaKeyFile.getParentFile().mkdirs();
            }
            mfaKeyFile.createNewFile();
            this._writeKeyInFile(mfaKeyFile);
        }
    }

    @Override
    public String getCryptoKey() {
        File cryptoFile = new File(AmetysHomeHelper.getAmetysHomeConfig(), this._getFilename());
        if (!cryptoFile.exists()) {
            this.getLogger().error("Unable to read the crypto key in file {}. This file does not exist", (Object)cryptoFile.getAbsolutePath());
            return null;
        }
        return super.getCryptoKey();
    }
}

