/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.authentication;

import dev.samstevens.totp.code.CodeGenerator;
import dev.samstevens.totp.code.DefaultCodeGenerator;
import dev.samstevens.totp.code.DefaultCodeVerifier;
import dev.samstevens.totp.exceptions.CodeGenerationException;
import dev.samstevens.totp.qr.QrData;
import dev.samstevens.totp.secret.DefaultSecretGenerator;
import dev.samstevens.totp.time.SystemTimeProvider;
import dev.samstevens.totp.time.TimeProvider;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.util.CryptoHelper;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.core.authentication.MultifactorAuthenticationCryptoHelper;
import org.ametys.plugins.core.impl.authentication.FormCredentialProvider;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.apache.commons.lang3.StringUtils;

public class MultifactorAuthenticationManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable,
Contextualizable,
Disposable {
    public static final String ROLE = MultifactorAuthenticationManager.class.getName();
    private static final String __SQL_TABLE_NAME = "Authentication_MFA";
    private static final String __QRCODE_ISSUER_KEY = "APPLICATION_PRODUCT_LABEL";
    private static final String __QRCODE_ISSUER_CATALOG = "application";
    private static final String __SEND_CODE_MAIL_SUBJECT_DEFAULT_PREFIX_KEY = "PLUGINS_CORE_MULTIFACTOR_AUTHENTICATION_MAIL_SUBJECT_DEFAULT_PREFIX";
    private static final String __SEND_CODE_MAIL_SUBJECT_KEY = "PLUGINS_CORE_MULTIFACTOR_AUTHENTICATION_MAIL_SUBJECT";
    private static final String __SEND_CODE_MAIL_BODY_TITLE_KEY = "PLUGINS_CORE_MULTIFACTOR_AUTHENTICATION_MAIL_BODY_TITLE";
    private static final String __SEND_CODE_MAIL_BODY_KEY = "PLUGINS_CORE_MULTIFACTOR_AUTHENTICATION_MAIL_BODY";
    private static final int __BUCKET_PERIOD_IN_SECONDS = 30;
    private static final int __ALLOWED_EMAIL_TIME_PERIOD_DISCREPANCY = 10;
    protected ServiceManager _serviceManager;
    protected Context _context;
    protected I18nUtils _i18nUtils;
    protected UserManager _userManager;
    protected SQLDatabaseTypeExtensionPoint _sqlDatabaseTypeExtensionPoint;
    protected CurrentUserProvider _currentUserProvider;
    protected UserLanguagesManager _userLanguagesManager;
    protected Map<String, MultifactorAuthenticationCryptoHelper> _cryptoHelpers = new HashMap<String, MultifactorAuthenticationCryptoHelper>();
    protected String _datasourceId;

    public void service(ServiceManager manager) throws ServiceException {
        this._serviceManager = manager;
        this._i18nUtils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._sqlDatabaseTypeExtensionPoint = (SQLDatabaseTypeExtensionPoint)manager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)manager.lookup(UserLanguagesManager.ROLE);
    }

    public void initialize() throws Exception {
        this._datasourceId = Config.getInstance() != null ? (String)Config.getInstance().getValue("runtime.assignments.multifactorauthentication") : "";
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void dispose() {
        this._cryptoHelpers.clear();
    }

    public int getEmailCodeDuration() {
        return 300;
    }

    public void initializeMFACryptoComponent(UserPopulation userPopulation) throws IllegalStateException {
        if (!this._cryptoHelpers.containsKey(userPopulation.getId())) {
            try {
                if (userPopulation.getCredentialProviders().stream().filter(FormCredentialProvider.class::isInstance).map(FormCredentialProvider.class::cast).anyMatch(FormCredentialProvider::useMultifactorAuthentication)) {
                    Configuration helperConfig = this._getCryptoHelperConfiguration(userPopulation);
                    MultifactorAuthenticationCryptoHelper cryptoHelper = new MultifactorAuthenticationCryptoHelper();
                    LifecycleHelper.setupComponent((Object)cryptoHelper, (Logger)new SLF4JLoggerAdapter(this.getLogger()), (Context)this._context, (ServiceManager)this._serviceManager, (Configuration)helperConfig);
                    this._cryptoHelpers.put(userPopulation.getId(), cryptoHelper);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("An error occured during the initialization of the multifactor authentication crypto component for UserPopulation '" + userPopulation.getId() + "'.", e);
            }
        }
    }

    private Configuration _getCryptoHelperConfiguration(UserPopulation userPopulation) {
        DefaultConfiguration helperConfig = new DefaultConfiguration("mfaCryptoHelper");
        DefaultConfiguration userPopulationConfig = new DefaultConfiguration("userPopulationId");
        userPopulationConfig.setValue(userPopulation.getId());
        helperConfig.addChild((Configuration)userPopulationConfig);
        return helperConfig;
    }

    public MultifactorAuthenticationCode generateMultifactorAuthenticationCode(UserIdentity userIdentity) throws RuntimeException {
        if (StringUtils.isEmpty((CharSequence)this._datasourceId)) {
            return null;
        }
        String secret = this._getUserSecret(userIdentity);
        try {
            ZonedDateTime now = ZonedDateTime.now();
            long currentBucket = Math.floorDiv(now.toEpochSecond(), 30);
            DefaultCodeGenerator codeGenerator = new DefaultCodeGenerator();
            String code = codeGenerator.generate(secret, currentBucket);
            ZonedDateTime expirationDate = now.plusSeconds(this.getEmailCodeDuration());
            return new MultifactorAuthenticationCode(code, expirationDate);
        }
        catch (CodeGenerationException e) {
            throw new RuntimeException("Unable to generate the multifactor authentication code for user " + UserIdentity.userIdentityToString(userIdentity) + ".", e);
        }
    }

    @Callable(rights={"*"})
    public Map<String, Object> getUserSecretForCurrentUser() {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        return Map.of("active", this.isAuthenticationApplicationActivated(userIdentity), "secret", this._getUserSecret(userIdentity));
    }

    @Callable(rights={"*"})
    public String renewSecretForCurrentUser() {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        return this.renewSecret(userIdentity);
    }

    public boolean isAuthenticationApplicationActivated(UserIdentity userIdentity) {
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(this._datasourceId);
            try (PreparedStatement statement2 = this._getSelectUseApplicationStatement(connection, userIdentity);
                 ResultSet resultSet = statement2.executeQuery();){
                if (resultSet.next()) {
                    boolean bl = resultSet.getBoolean("use_application");
                    return bl;
                }
            }
            boolean statement2 = false;
            return statement2;
        }
        catch (SQLException e) {
            throw new RuntimeException("Communication error with the database. Unable to retrieve the multifactor authentication state for user " + UserIdentity.userIdentityToString(userIdentity) + ".", e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
    }

    private PreparedStatement _getSelectUseApplicationStatement(Connection connection, UserIdentity user) throws SQLException {
        String dbType = ConnectionHelper.getDatabaseType(connection);
        String sqlRequest = "SELECT use_application FROM " + this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, __SQL_TABLE_NAME) + " WHERE login=? AND population_id=?";
        PreparedStatement statement = connection.prepareStatement(sqlRequest);
        statement.setString(1, user.getLogin());
        statement.setString(2, user.getPopulationId());
        return statement;
    }

    @Callable(rights={"*"})
    public void authenticationApplicationForCurrentUser(boolean value) {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        this._storeAuthenticationActivationInDataSource(userIdentity, value);
    }

    private void _storeAuthenticationActivationInDataSource(UserIdentity userIdentity, boolean useApplication) throws RuntimeException {
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(this._datasourceId);
            String dbType = ConnectionHelper.getDatabaseType(connection);
            PreparedStatement statement = connection.prepareStatement("UPDATE " + this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, __SQL_TABLE_NAME) + " SET use_application=? WHERE login=? AND population_id=?");
            statement.setBoolean(1, useApplication);
            statement.setString(2, userIdentity.getLogin());
            statement.setString(3, userIdentity.getPopulationId());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Communication error with the database. Unable to store the generated secret for multifactor authentication for user " + UserIdentity.userIdentityToString(userIdentity) + ".", e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
    }

    public QrData getCurrentUserQrData() {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        String secret = this._getUserSecret(userIdentity);
        I18nizableText i18nIssuer = new I18nizableText(__QRCODE_ISSUER_CATALOG, __QRCODE_ISSUER_KEY);
        String issuer = this._i18nUtils.translate(i18nIssuer);
        return new QrData.Builder().secret(secret).label(userIdentity.getLogin()).issuer(issuer).period(30).build();
    }

    private String _getUserSecret(UserIdentity userIdentity) {
        return this._getSecretFromDatasourceIfExists(userIdentity).orElseGet(() -> this._generateSecret(userIdentity));
    }

    public boolean isValidMultifactorAuthenticationCode(UserIdentity userIdentity, String multifactorAuthenticationCode) throws RuntimeException {
        Optional<String> optionalSecret = this._getSecretFromDatasourceIfExists(userIdentity);
        if (optionalSecret.isPresent()) {
            SystemTimeProvider timeProvider = new SystemTimeProvider();
            DefaultCodeGenerator codeGenerator = new DefaultCodeGenerator();
            DefaultCodeVerifier verifier = new DefaultCodeVerifier((CodeGenerator)codeGenerator, (TimeProvider)timeProvider);
            verifier.setTimePeriod(30);
            verifier.setAllowedTimePeriodDiscrepancy(10);
            String secret = optionalSecret.get();
            return verifier.isValidCode(secret, multifactorAuthenticationCode);
        }
        return false;
    }

    private Optional<String> _getSecretFromDatasourceIfExists(UserIdentity userIdentity) throws RuntimeException {
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(this._datasourceId);
            try (Object statement = this._getSelectSecretStatement(connection, userIdentity);
                 ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    String cryptedSecret = resultSet.getString("secret");
                    MultifactorAuthenticationCryptoHelper cryptoHelper = this._cryptoHelpers.get(userIdentity.getPopulationId());
                    String secret = cryptoHelper.decrypt(cryptedSecret);
                    Optional<String> optional = Optional.of(secret);
                    return optional;
                }
            }
            statement = Optional.empty();
            return statement;
        }
        catch (CryptoHelper.WrongKeyException e) {
            throw new RuntimeException("Secret of user " + UserIdentity.userIdentityToString(userIdentity) + " cannot be decrypted. Unable to retrieve the multifactor authentication secret.", e);
        }
        catch (SQLException e) {
            throw new RuntimeException("Communication error with the database. Unable to retrieve the multifactor authentication secret for user " + UserIdentity.userIdentityToString(userIdentity) + ".", e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
    }

    /*
     * Loose catch block
     */
    public String renewSecret(UserIdentity userIdentity) {
        Connection connection = null;
        try {
            PreparedStatement statement;
            block12: {
                String string;
                block13: {
                    connection = ConnectionHelper.getConnection(this._datasourceId);
                    DefaultSecretGenerator secretGenerator = new DefaultSecretGenerator();
                    String newSecret = secretGenerator.generate();
                    statement = this._getUpdateSecretStatement(connection, userIdentity, newSecret);
                    if (statement.executeUpdate() != 1) break block12;
                    string = newSecret;
                    if (statement == null) break block13;
                    {
                        catch (Throwable throwable) {
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    statement.close();
                }
                return string;
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                throw new RuntimeException("Secret of user " + UserIdentity.userIdentityToString(userIdentity) + " cannot be updated");
            }
            catch (SQLException e) {
                throw new RuntimeException("Communication error with the database. Unable to retrieve the multifactor authentication secret for user " + UserIdentity.userIdentityToString(userIdentity) + ".", e);
            }
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
    }

    private PreparedStatement _getUpdateSecretStatement(Connection connection, UserIdentity user, String newSecret) throws SQLException {
        String dbType = ConnectionHelper.getDatabaseType(connection);
        String sqlRequest = "UPDATE " + this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, __SQL_TABLE_NAME) + " SET secret=? WHERE login=? AND population_id=?";
        MultifactorAuthenticationCryptoHelper cryptoHelper = this._cryptoHelpers.get(user.getPopulationId());
        String cryptedSecret = cryptoHelper.encrypt(newSecret);
        PreparedStatement statement = connection.prepareStatement(sqlRequest);
        statement.setString(1, cryptedSecret);
        statement.setString(2, user.getLogin());
        statement.setString(3, user.getPopulationId());
        return statement;
    }

    private PreparedStatement _getSelectSecretStatement(Connection connection, UserIdentity user) throws SQLException {
        String dbType = ConnectionHelper.getDatabaseType(connection);
        String sqlRequest = "SELECT secret FROM " + this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, __SQL_TABLE_NAME) + " WHERE login=? AND population_id=?";
        PreparedStatement statement = connection.prepareStatement(sqlRequest);
        statement.setString(1, user.getLogin());
        statement.setString(2, user.getPopulationId());
        return statement;
    }

    private String _generateSecret(UserIdentity userIdentity) throws RuntimeException {
        DefaultSecretGenerator secretGenerator = new DefaultSecretGenerator();
        String secret = secretGenerator.generate();
        this._storeSecretInDataSource(userIdentity, secret);
        return secret;
    }

    private void _storeSecretInDataSource(UserIdentity userIdentity, String secret) throws RuntimeException {
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(this._datasourceId);
            String dbType = ConnectionHelper.getDatabaseType(connection);
            PreparedStatement statement = connection.prepareStatement("INSERT INTO " + this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, __SQL_TABLE_NAME) + " (login, population_id, secret) VALUES (?, ?, ?)");
            statement.setString(1, userIdentity.getLogin());
            statement.setString(2, userIdentity.getPopulationId());
            MultifactorAuthenticationCryptoHelper cryptoHelper = this._cryptoHelpers.get(userIdentity.getPopulationId());
            String cryptedSecret = cryptoHelper.encrypt(secret);
            statement.setString(3, cryptedSecret);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Communication error with the database. Unable to store the generated secret for multifactor authentication for user " + UserIdentity.userIdentityToString(userIdentity) + ".", e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
    }

    public void sendMultifactorAuthenticationCodeByMail(Request request, UserIdentity userIdentity, String multifactorAuthenticationCode) throws RuntimeException {
        try {
            User user = this._userManager.getUser(userIdentity);
            String recipient = user.getEmail();
            if (StringUtils.isEmpty((CharSequence)recipient)) {
                throw new RuntimeException("Unable to send the multifactor authentication code to user " + UserIdentity.userIdentityToString(userIdentity) + ". This user has no email address");
            }
            String language = user.getLanguage();
            String i18nCatalog = "plugin.core-impl";
            String allowedTimePeriodInMinutes = String.valueOf(this.getEmailCodeDuration() / 60);
            String subjectPrefix = this._i18nUtils.translate(this._getMailSubjectPrefix(request), language);
            List<String> params = List.of(subjectPrefix, multifactorAuthenticationCode, allowedTimePeriodInMinutes);
            I18nizableText subjectWithParams = new I18nizableText(i18nCatalog, __SEND_CODE_MAIL_SUBJECT_KEY, params);
            String subject = this._i18nUtils.translate(subjectWithParams, language);
            String body = StandardMailBodyHelper.newHTMLBody().withTitle(new I18nizableText(i18nCatalog, __SEND_CODE_MAIL_BODY_TITLE_KEY)).withMessage(new I18nizableText(i18nCatalog, __SEND_CODE_MAIL_BODY_KEY, params)).withFooterBottomText(StandardMailBodyHelper.AUTOGENERATED_DO_NOT_ANSWER_TEXT).withLanguage(language).build();
            SendMailHelper.newMail().withSubject(subject).withHTMLBody(body).withRecipient(recipient).sendMail();
        }
        catch (MessagingException | IOException e) {
            throw new RuntimeException("Unable to send the multifactor authentication code to user " + UserIdentity.userIdentityToString(userIdentity) + ".", e);
        }
    }

    protected I18nizableText _getMailSubjectPrefix(Request request) {
        return new I18nizableText("plugin.core-impl", __SEND_CODE_MAIL_SUBJECT_DEFAULT_PREFIX_KEY);
    }

    public record MultifactorAuthenticationCode(String code, ZonedDateTime expirationDate) {
    }
}

